#!/usr/bin/perl

local ($i, $form, $field, @cmd, @formField, @provider, @device, @phonebook, $chapter, $key, $value);

sub Chooser {
   local ($i, $loc);

   if ($form{'file'} =~ /^(.*\/)([^\/]*)$/) { $dir = $1; $file = $2; }
   else { $dir = "/"; $file = ""; }
   if (!(-d $dir)) { $dir = "/"; $file = ""; }

   if ($form{'frame'} == 0) {
   	# base frame
      &PrintHeader ();
   	if ($form{'type'} == 0) { print "<title>Choose File..</title>\n"; }
   	elsif ($form{'type'} == 1) { print "<title>Choose Directory..</title>\n";}
   	print "<frameset rows='*,50'>\n";
   	print "<frame marginwidth=5 marginheight=5 name=topframe ",
	     "src=\"$ENV{'SCRIPT_NAME'}/chooser?frame=1&file=$form{'file'}&type=$form{'type'}&chooser=1\">\n";
   	print "<frame marginwidth=0 marginheight=0 name=bottomframe ",
	      "src=\"$ENV{'SCRIPT_NAME'}/chooser?frame=2&file=$form{'file'}&type=$form{'type'}&chooser=1\" ",
	      "scrolling=no>\n";
   	print "</frameset>\n";
   } elsif ($form{'frame'} == 1) {
      # List of files in this directory
      &PrintHeader ();

      print <<EOF;
<script>
function fileclick(f, d)
{
curr = top.frames[1].document.forms[0].elements[1].value;
if (curr == f) {
	// Double-click! Enter directory or select file
	if (d) {
		// Enter this directory
		location = "$ENV{'SCRIPT_NAME'}/chooser?frame=1&type=$form{'type'}&chooser=1&file="+f+"/";
		}
	else {
		// Select this file and close the window
		top.ifield.value = f;
		top.close();
		}
	}
else {
	top.frames[1].document.forms[0].elements[1].value = f;
	}
}

function parentdir(p)
{
top.frames[1].document.forms[0].elements[1].value = p;
location = "$ENV{'SCRIPT_NAME'}/chooser?frame=1&type=$form{'type'}&chooser=1&file="+p;
}
</script>
EOF

   print "<b>Directory of $dir</b>\n";
   print "<table width=\"100%\">\n";
   opendir(DIR, $dir);
   foreach $f (sort { $a cmp $b } readdir(DIR)) {
      $path = "$dir$f";
      if ($f eq ".") { next; }
      if ($f eq ".." && $dir eq "/") { next; }
      if (!(-d $path) && $form{'type'} == 1) { next; }
      @st = stat($path);
      print "<tr>\n";
      $isdir = 0;
      if (-d $path) { $isdir = 1; }
      if ($f eq "..") {
         $dir =~ /^(.*\/)[^\/]+\/$/;
         $link = "<a href=\"\" onClick='parentdir(\"$1\"); return false'>";
      } else {
         $link = "<a href=\"\" onClick='fileclick(\"$path\", $isdir); return false'>";
      }
      print "<td nowrap>$link$f</a></td>\n";
      printf "<td nowrap>%s</td>\n",
			$st[7] > 1000000 ? int($st[7]/1000000)." Mb" :
			$st[7] > 1000 ? int($st[7]/1000)." Kb" :
			$st[7];
      @tm = localtime($st[9]);
      printf "<td nowrap><tt>%.2d/%.2d/%.4d</tt></td>\n",
			$tm[3], $tm[4]+1, $tm[5]+1900;
      printf "<td nowrap><tt>%.2d:%.2d</tt></td>\n", $tm[1], $tm[2];
      print "</tr>\n";
   }
   closedir(DIR);
   print "</table>\n";
   } elsif ($form{'frame'} == 2) {
   # Current file and OK/cancel buttons
   &PrintHeader ();
   print <<EOF;
<script>
function filechosen()
{
top.ifield.value = document.forms[0].path.value;
top.close();
}
</script>
EOF

   print "<table width=\"100%\">\n";
   print "<form onSubmit='filechosen(); return false'>\n";
   print "<tr><td><input type=submit value=\"Ok\"></td>\n";
   print "<td align=right><input name=path size=45 value=\"$dir$file\"></td></tr>\n";
   print "</form>\n";
   print "</table>\n";
   }
}

sub ChkLocalClient {
   return ($ENV{'REMOTE_HOST'} eq $ENV{'SERVER_NAME'});
}

sub OpenIniFile {
   local $fp = $_[0];
   local $rc;

   $rc = 0;
   open ($fp, "<".$_[1]) or ($rc = -1);
   return ($rc);
}

sub CloseIniFile {
   local $fp = $_[0];

   close ($fp);
}

sub ReadIniFileLine {
   local $fp = $_[0];
   local ($zeile, $len, $rc);

   $value = "";
   $len = 0;
   while ((!eof ($fp)) && ($len == 0)) {
      $zeile = <$fp>;
      chomp ($zeile);
      $zeile =~ s/;.*$//g;
      $zeile =~ s/^\s+//g;
      $zeile =~ s/\s+$//g;
      $len = length ($zeile);
   }
   if ($len > 0) {
      if ((substr ($zeile, 0, 1) eq '[') && (substr ($zeile, -1)  eq ']')) {
         $chapter = substr ($zeile, 1, len - 1);
         $key = "";
         $rc = 0;
      } else {
         if (index ($zeile, "=") >= 0) {
            ($key, $value) = split(/=/, $zeile);
            $rc = 1;
         } else {
            $value = $zeile;
            $rc = 0;
         }
      }
      $_[1] = $chapter;
      $_[2] = $key;
      $_[3] = $value;
   } else {
      $_[1] = "";
      $_[2] = "";
      $_[3] = "";
      $rc = -1;
   }
   $_[1] =~ s/^\s+//g;
   $_[1] =~ s/\s+$//g;
   $_[2] =~ s/^\s+//g;
   $_[2] =~ s/\s+$//g;
   $_[3] =~ s/^\s+//g;
   $_[3] =~ s/s+.$//g;
   $_[1] = lc ($_[1]);
   $_[2] = lc ($_[2]);
   return ($rc);
}

sub PrintHeader {
   print "Content-type: text/html\n\n";
}

sub PrintFooter {
   print "<P ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=\"-1\">\n";
   print "&copy; 1998, Dipl.-Inform. Wolfgang Bcherer\n";
   print "</FONT>\n";
   print "<HR>\n";
   print "<TABLE Border=0 WIDTH=\"100%\">\n";
   print "   <TR>\n";
   print "      <TD VALIGN=top ALIGN=left>\n";
   print "         <ADDRESS>\n";
   print "            <b>Bcherer&nbsp;Angewandte&nbsp;Informatik</b><br>\n";
   print "            Scheffelstra&szlig;e 17a<br>\n";
   print "            D-76135&nbsp;Karlsruhe<br>\n";
   print "         </ADDRESS>\n";
   print "      </TD>\n";
   print "      <TD  VALIGN=TOP ALIGN=right>\n";
   print "            Tel:&nbsp;+49&nbsp;(0)721&nbsp;9109550<br>\n";
   print "            Fax:&nbsp;+49&nbsp;(0)721&nbsp;9109555<br>\n";
   print "            Email:&nbsp;<A HREF=\"mailto:info\@bai.de\" onMouseOver=\"status='mail us your comments'; return true;\">info\@bai.de</A><br>\n";
   print "            WWW:&nbsp;<A HREF=\"http://www.bai.de\" onMouseOver=\"status='Homepage - Bcherer Angewandte Informatik'; return true;\">http://www.bai.de</A>\n";
   print "      </TD>\n";
   print "   </TR>\n";
   print "</TABLE>\n";
   print "</BODY>\n";
   print "</HTML>\n";
   exit (0);
}

sub Error {
   print ("<H3>ERROR!!!</H3>".$_[0]."<P>\n");
   &PrintFooter ();
}

if ($ENV{'REQUEST_METHOD'} eq "POST") {
   read(STDIN, $data, $ENV{'CONTENT_LENGTH'});
} else {
   $data = $ENV{'QUERY_STRING'};
}
@formField = split(/&/, $data);
foreach $field (@formField) {
   $field =~ s/\+/ /g;
   ($name, $value) = split(/=/, $field, 2);
   $name =~ s/%(..)/pack("c",hex($1))/ge;
   $value =~ s/%(..)/pack("c",hex($1))/ge;
   if ($name eq "sms") {
      $value =~ s/[<]/&lt;/g;
      $value =~ s/[>]/&gt;/g;
   }
   $form{$name} = $value;
}
if (($ENV{'PATH_INFO'} eq "/chooser") || ($ENV{'PATH_INFO'} eq "$ENV{'SCRIPT_NAME'}/chooser") || ($form{'chooser'} ne "")) {
   &Chooser ();
   exit (0);
}
$|=1;
&PrintHeader ();
print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
print "<HTML>\n";
print "<HEAD>\n";
print "<TITLE>SendSMS</TITLE>\n";
print "</HEAD>\n";
print "<BODY BGCOLOR=\"#FFFFFF\">\n";
if (&OpenIniFile ('SENDSMS_INI', "sendsms.ini") >= 0) {
   while (&ReadIniFileLine ('SENDSMS_INI', $chapter, $key, $value) >= 0) {
      if ($value ne "") {$ini{$key} = $value;}
   }
   $ini{'path'} = $ini{'sendsms'};
   if (($i = rindex ($ini{'path'}, "/", length ($ini{'path'}))) >= 0) {
      $ini{'path'} = substr ($ini{'path'}, 0, $i + 1);
   } else {
      if (($i = rindex ($ini{'path'}, "\\", length ($ini{'path'}))) >= 0) {
         $ini{'path'} = substr ($ini{'path'}, 0, $i + 1);
      }
   }
   &CloseIniFile ('SENDSMS_INI');
} else {
   if ($ini{'language'} eq "german") {&Error ("Kein Zugriff auf Datei 'sendsms.ini'!");}
   else {&Error ("can't open the file 'sendsms.ini'!");}
}

if (&OpenIniFile ('SENDSMS_CFG', $ini{'config'}) >= 0) {
   while (&ReadIniFileLine ('SENDSMS_CFG', $chapter, $key, $value) >= 0) {
      if (($chapter eq "device") && ($key eq "name")) {push (@device, $value);}
   }
   &CloseIniFile ('SENDSMS_CFG');
#   if (@device <= 0) {&Error ("No device configured!");}
} else {
   if ($ini{'language'} eq "german") {&Error ("Kein Zugriff auf Datei '".$ini{'config'}."'!");}
   else {&Error ("can't open the file '".$ini{'config'}."'!");}
}

if (&OpenIniFile ('SENDSMS_PRO', $ini{'provider'}) >= 0) {
   while (&ReadIniFileLine ('SENDSMS_PRO', $chapter, $key, $value) >= 0) {
      if (($chapter ne "") && ($key eq "") && $value eq "") {push (@provider, $chapter);}
   }
   &CloseIniFile ('SENDSMS_PRO');
   if (@provider <= 0) {&Error ("No provider configured!");}
} else {
   if ($ini{'language'} eq "german") {&Error ("Kein Zugriff auf Datei '".$ini{'provider'}."'!");}
   else {&Error ("can't open the file '".$ini{'provider'}."'!");}
}

if ($ini{'phonebook'} ne "") {
   if (&OpenIniFile ('SENDSMS_PBK', $ini{'phonebook'}) >= 0) {
      while (&ReadIniFileLine ('SENDSMS_PBK', $chapter, $key, $value) >= 0) {
         if (($chapter ne "") && ($key ne "") && ($value ne "")) {push (@phonebook, {'alias' => $key, 'provider' => $chapter});}
      }
      &CloseIniFile ('SENDSMS_PBK');
   } else {
      if ($ini{'language'} eq "german") {&Error ("Kein Zugriff auf Datei '".$ini{'phonebook'}."'!");}
      else {&Error ("can't open the file '".$ini{'phonebook'}."'!");}
   }
}

if (($ENV{'PATH_INFO'} eq "/send") || ($ENV{'PATH_INFO'} eq "$ENV{'SCRIPT_NAME'}/send")) {
   push (@cmd, $ini{'sendsms'});
   if ($ini{'config'} ne "") {push (@cmd, "-c".$ini{'config'});}
   if ($ini{'provider'} ne "") {push (@cmd, "-r".$ini{'provider'});}
   if ($ini{'phonebook'} ne "") {push (@cmd, "-b".$ini{'phonebook'});}
   if ($ini{'userexit'} ne "") {push (@cmd, "-u".$ini{'userexit'});}
   if ($form{'verbose'} eq "1") {push (@cmd, "-v");}
   if ($form{'spool'} eq "spool") {
      push (@cmd, "-s");
   } else {
      if ($form{'spool'} eq "send") {push (@cmd, "-n");}
   }
   if ($form{'originator'} ne "") {push (@cmd, "-o".$form{'originator'});}
   if (($form{'device'} ne "") && ($form{'device'} ne "(auto)")) {push (@cmd, "-d".$form{'device'});}
   if ($form{'addrtype'} eq "phone") {
      if ($form{'phone'} eq "") {
         if ($ini{'language'} eq "german") {&Error ("Kein Empfnger angegeben!!");}
         else {&Error ("No recipient specified!!");}
      }
      if (($form{'provider'} ne "") && ($form{'provider'} ne "(auto)")) {push (@cmd, "-p".$form{'provider'});}
      push (@cmd, $form{'phone'});
   } else {
      if ($form{'addrtype'} eq "phonebook") {
         if ($form{'phonebook'} eq "") {
            if ($ini{'language'} eq "german") {&Error ("Kein Empfnger angegeben!!");}
            else {&Error ("No recipient specified!!");}
         }
         ($key, $value) = split(/;/, $form{'phonebook'}, 2);
         push (@cmd, $key);
         if ($value ne "") {push (@cmd, $value);}
      } else {
         if (($form{'group'} eq "") || ($form{'group'} eq $ini{'path'})) {
            if ($ini{'language'} eq "german") {&Error ("Kein Empfnger angegeben!!");}
            else {&Error ("No recipient specified!!");}
         }
         push (@cmd, "-g".$form{'group'});
      }
   }
   if ((!(&ChkLocalClient ())) || ($form{'msgType'} eq "text")) {
      if ($form{'sms'} eq "") {
         if ($ini{'language'} eq "german") {&Error ("Keine Nachricht angegeben!!");}
         else {&Error ("No message specified!!");}
      }
      push (@cmd, "-tiso8859");
      if ($ENV{'WINDIR'}) {
         $form{'sms'} =~ s/\"/\'/g;
         push (@cmd, "\"".$form{'sms'}."\"");
      } else {
         push (@cmd, $form{'sms'});
      }
   } else {
      if ($form{'file'} eq "") {
         if ($ini{'language'} eq "german") {&Error ("Keine Nachricht angegeben!!");}
         else {&Error ("No message specified!!");}
      }
      if ($form{'charset'} eq "iso8859") {push (@cmd, "-tiso8859");}
      else {if ($form{'charset'} eq "cp850") {push (@cmd, "-tcp850");}
      else {if ($form{'charset'} eq "binary") {push (@cmd, "-tbinary");}}}
      push (@cmd, "-f".$form{'file'});
   }
   if ($ini{'language'} eq "german") {
      print "<B><I>SendSMS</I></B> wird aufgerufen, bitte warten...<P>\n";
   } else {
      print "<B><I>SendSMS</I></B> will be executed, please wait...<P>\n";
   }
   print "<listing>\n";
   for ($i = 0; $i < @cmd; $i++) {
      print @cmd[$i]." ";
   }
   print "</listing>\n";
   if (!$ENV{'SERVER_PROTOCOL'}) {$ENV{'SERVER_PROTOCOL'} = "HTTP/1.0";}
   if ($ENV{'WINDIR'}) {
      print `@cmd`;
   } else {
      system (@cmd);
   }
   print "<FORM ACTION=\"$ENV{'SCRIPT_NAME'}\"><CENTER>\n";
   if ($ini{'language'} eq "german") {
      print "<INPUT TYPE=submit VALUE=\"Neue Nachricht\">\n";
   } else {
      print "<INPUT TYPE=submit VALUE=\"new message\">\n";
   }
   print "</CENTER></FORM>\n"
} else {
   print "<script language=\"Javascript\" type=\"text/javascript\">\n";
   if ($ini{'language'} eq "german") {
      print "<!-- -->ACHTUNG!!! Ihr Web-Browser unterst&uuml;zt kein JavaScript! Benutzen Sie\n";
      print "<!-- -->einen anderen Browser, um die volle Funktionalit&auml;t von SendSMS zu erhalten.\n";
   } else {
      print "<!-- -->ATTENTION!!! Your Web browser doesn't support JavaScript! Pleas use another\n";
      print "<!-- -->browser, to use the full functionallity of SendSMS.\n";
   }
   print "<!--\n";
   print "function FileChooser(feld) {\n";
   print "   if (feld == \"group\")\n";
   print "      document.write(\"<input type=button onClick='ifield = document.SendSMS.group; chooser = window.open(\\\"$ENV{'SCRIPT_NAME'}/chooser?type=0&file=\\\"+ifield.value, \\\"chooser\\\", \\\"toolbar=no,menubar=no,scrollbars=no,width=600,height=400\\\"); chooser.ifield = ifield' value=...>\")\n";
   print "   else\n";
   print "      document.write(\"<input type=button onClick='ifield = document.SendSMS.file; chooser = window.open(\\\"$ENV{'SCRIPT_NAME'}/chooser?type=0&file=\\\"+ifield.value, \\\"chooser\\\", \\\"toolbar=no,menubar=no,scrollbars=no,width=600,height=400\\\"); chooser.ifield = ifield' value=...>\")\n";
   print "}\n\n";
   print "function ChkValues() {\n";
   print "   var flag = Boolean;\n";
   print "\n";
   print "   flag = false;\n";
   print "   if ((document.SendSMS.addrtype[0].checked == true) && (document.SendSMS.phone.value.length > 0))\n";
   print "      flag = true;\n";
   print "   if ((document.SendSMS.addrtype[1].checked == true) && (document.SendSMS.phonebook.selectedIndex > 0))\n";
   print "      flag = true;\n";
   if (&ChkLocalClient ()) {
   print "   if ((document.SendSMS.addrtype[2].checked == true) && (document.SendSMS.group.value.length > 0) && (document.SendSMS.group.value != \"".$ini{'path'}."\"))\n";
   print "      flag = true;\n";
   }
   print "   if (flag == false)\n";
   if ($ini{'language'} eq "german") {
      print "      window.alert('Kein Empfnger angegeben!!');\n";
   } else {
      print "      window.alert('No recipient specified!!');\n";
   }
   print "   else {\n";
   print "      flag = false;\n";
   if (&ChkLocalClient ()) {
   print "      if ((document.SendSMS.msgType[0].checked == true) && (document.SendSMS.sms.value.length > 0))\n";
   print "         flag = true;\n";
   print "      if ((document.SendSMS.msgType[1].checked == true) && (document.SendSMS.file.value.length > 0))\n";
   print "         flag = true;\n";
   } else {
   print "      if (document.SendSMS.sms.value.length > 0)\n";
   print "         flag = true;\n";
   }
   print "      if (flag == false)\n";
   if ($ini{'language'} eq "german") {
      print "         window.alert('Keine Nachricht angegeben!!');\n";
   } else {
      print "         window.alert('No message specified!!');\n";
   }
   print "   }\n";
   print "   return (flag);\n";
   print "}\n";
   print "//-->\n";
   print "</script>\n";
   print "\n";
   print "<FORM ID=\"SendSMS\" NAME=\"SendSMS\" METHOD=POST ACTION=\"$ENV{'SCRIPT_NAME'}/send\" onSubmit=\"return(ChkValues())\">\n";

   print "<table width=\"100%\">\n";
   print "<tr><td>\n";
   if ($ini{'language'} eq "german") {
      print "<B>Absender: </B>\n";
   } else {
      print "<B>Originator: </B>\n";
   }
   print "<INPUT TYPE=text NAME=originator VALUE=\"";
   if ($ENV{'REMOTE_USER'}) {
      print $ENV{'REMOTE_USER'};
      if ($ENV{'REMOTE_HOST'}) {print "@".$ENV{'REMOTE_HOST'};}
   }
   print "\" SIZE=30>\n";
   print "<P>\n";
   print "</td><td align=right>\n";
   print "<FONT SIZE=\"+3\"><B><I>SendSMS</I></B></FONT>\n";
   print "</td></tr>\n";
   print "</table><p>\n";
   if ($ini{'language'} eq "german") {
      print "<B>Empf&auml;nger:</B><BR>\n";
   } else {
      print "<B>Receiver:</B><BR>\n";
   }
   print "<table border=1 width=\"100%\">\n";
   print "<tr><td>\n";
   print "<INPUT TYPE=radio CHECKED NAME=addrtype VALUE=phone>";
   if ($ini{'language'} eq "german") {
      print " Telefonnummer\n";
   } else {
      print " phone number\n";
   }
   print "</td><td>\n";
   print "<INPUT TYPE=text NAME=phone VALUE=\"\" SIZE=30>";
   if ($ini{'language'} eq "german") {
      print " Telefonnummer<BR>\n";
   } else {
      print " phone number<BR>\n";
   }
   print "<SELECT NAME=provider SIZE=1>\n";
   print "<OPTION SELECTED>(auto)</OPTION>\n";
   for ($i = 0; $i < @provider; $i++) {
      print "<OPTION>".$provider[$i]."</OPTION>\n";
   }
   if ($ini{'language'} eq "german") {
      print "</SELECT> Provider<P>\n";
   } else {
      print "</SELECT> provider<P>\n";
   }
   print "</td></tr>\n";
   if (@phonebook > 0) {
      print "<tr><td>\n";
      print "<INPUT TYPE=radio NAME=addrtype VALUE=phonebook>";
      if ($ini{'language'} eq "german") {
         print " Telefonbuch\n";
      } else {
         print " phonebook\n";
      }
      print "</td><td>\n";
      print "<SELECT NAME=phonebook SIZE=1>\n";
      print "<OPTION SELECTED></OPTION>\n";
      for ($i = 0; $i < @phonebook; $i++) {
         print "<OPTION VALUE=\"-p".$phonebook[$i]->{'provider'}.";".$phonebook[$i]->{'alias'}."\">".$phonebook[$i]->{'alias'}." [".$phonebook[$i]->{'provider'}."]</OPTION>\n";
      }
      print "</SELECT>\n";
      print "</td></tr>\n";
   }
   if (&ChkLocalClient ()) {
      print "<tr>\n";
      print "<td><INPUT TYPE=radio NAME=addrtype VALUE=group>";
      if ($ini{'language'} eq "german") {
         print " Gruppe\n";
      } else {
         print " group\n";
      }
      print "</td><td>\n";
      print "<INPUT TYPE=text NAME=group VALUE=\"".$ini{'path'}."\" SIZE=30>\n";
      print "<script language=\"Javascript\" type=\"text/javascript\">\n<!--\n";
      print "FileChooser(\"group\");\n";
      print "//-->\n</script>\n";
      print "</td></tr>\n";
   }
   print "</table>\n";
   print "<P>\n";
   if ($ini{'language'} eq "german") {
      print "<B>Nachricht:</B><BR>\n";
   } else {
      print "<B>Message:</B><BR>\n";
   }
   print "<table border=1 width=\"100%\">\n";
   print "<tr>\n";
   if (&ChkLocalClient ()) {
      print "<td><INPUT TYPE=radio CHECKED NAME=msgType VALUE=text>";
      if ($ini{'language'} eq "german") {
         print " Text\n";
      } else {
         print " text\n";
      }
      print "</td>\n";
   }
   print "<td>\n";
   print "<TEXTAREA NAME=sms ROWS=3 COLS=60></TEXTAREA>\n";
   print "</td></tr>\n";
   if (&ChkLocalClient ()) {
      print "<tr><td>\n";
      print "<INPUT TYPE=radio NAME=msgType VALUE=file>";
      if ($ini{'language'} eq "german") {
         print " Datei\n";
      } else {
         print " file\n";
      }
      print "</td><td>\n";
      print "<INPUT TYPE=text NAME=file VALUE=\"\" SIZE=60>\n";
      print "<script language=\"Javascript\" type=\"text/javascript\">\n<!--\n";
      print "FileChooser(\"file\");\n";
      print "//-->\n</script>\n";
      print "<SELECT NAME=charset SIZE=1>\n";
      print "<OPTION SELECTED VALUE=\"(auto)\">(auto)</OPTION>\n";
      print "<OPTION VALUE=iso8859>ISO 8859-1</OPTION>\n";
      print "<OPTION VALUE=cp850>CP850</OPTION>\n";
      print "<OPTION VALUE=binary>binary</OPTION>\n";
      print "</select>\n";
      print "</td></tr>\n";
   }
   print "</table>\n";
   print "<P>\n";
   if ($ini{'language'} eq "german") {
      print "<B>Optionen:</B> (fr Experten)<BR>\n";
   } else {
      print "<B>Options: (for experts)</B><BR>\n";
   }
   print "<table width=\"100%\">\n";
   print "<tr><td>\n";
   print "<INPUT TYPE=checkbox NAME=verbose VALUE=1>verbose -- ";
   print "<SELECT NAME=spool SIZE=1>\n";
   print "<OPTION SELECTED VALUE=\"(auto)\">(auto)</OPTION>\n";
   if ($ini{'language'} eq "german") {
      print "<OPTION VALUE=send>senden</OPTION>\n";
      print "<OPTION VALUE=spool>spoolen</OPTION>\n";
   } else {
      print "<OPTION VALUE=send>send</OPTION>\n";
      print "<OPTION VALUE=spool>spool</OPTION>\n";
   }
   print "</select>\n";
   if (@device > 1) {
      print " -- <SELECT NAME=device SIZE=1>\n";
      print "<OPTION SELECTED>(auto)</OPTION>\n";
      for ($i = 0; $i < @device; $i++) {
         print "<OPTION>".$device[$i]."</OPTION>\n";
      }
      if ($ini{'language'} eq "german") {
         print "</SELECT> Device\n";
      } else {
         print "</SELECT> device\n";
      }
   }
   print "</td><td align=right>\n";
   if ($ini{'language'} eq "german") {
      print "<INPUT TYPE=submit VALUE=\"Ausfhren\">\n";
      print "<INPUT TYPE=reset VALUE=\"Lschen\">\n";
   } else {
      print "<INPUT TYPE=submit VALUE=\"Execute\">\n";
      print "<INPUT TYPE=reset VALUE=\"Reset\">\n";
   }
   print "</td></tr>\n";
   print "</table>\n";
   print "</FORM>\n";
   print "<script language=\"Javascript\" type=\"text/javascript\">\n<!--\n";
   print "if (document.SendSMS.addrtype[0].checked == true)\n";
   print "   document.SendSMS.phone.focus();\n";
   print "if (document.SendSMS.addrtype[1].checked == true)\n";
   print "   document.SendSMS.phonebook.focus();\n";
   print "if (document.SendSMS.addrtype[2].checked == true)\n";
   print "   document.SendSMS.group.focus();\n";
   print "//-->\n</script>\n";
}
&PrintFooter ();
