// This is the structure for phonebook entries in ZOC.
// Maybe someone likes to use this for a converter program
// Send any questions to m.schmidt@emtec.msn.sub.org


// !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!!
// A PHONEBK file must begin with an nine byte header string "BOOKV.VV\032"
// where V.VV is the version of ZOC which introduced this phonebook format.
// All PHONEBK files compatible with this format will carry this version,
// even if written with a future version of ZOC 
// !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!! !!IMPORTANT!!


#define PH_FILENAME "PHONEBK"
#define PH_INIT  	"BOOK"
#define PH_VERSION	"1.40"
#define PH_TRAIL	"\032"
#define PH_HEADER   (PH_INIT PH_VERSION PH_TRAIL)
#define PH_HEADER_OLD   (PH_INIT "0.98" PH_TRAIL)

#ifndef XRECORD		// internal sub-record
	#define XRECORD void
#endif

// Not packed, each member aligned to 4-byte boundary
// int=32bit
#pragma pack(4)


typedef struct _PHONEBOOK_098 {
	int 	book;				// nr of phonebook to put it in
	char	name[32+1],			// name
			value[64+1],		// number or name of script
			seropt[10+1],		// serial options like 38400-8N1
			optfile[64+1],		// name of options file to load
			logname[64+1],		// name of logfile to open
			waitsend[160+1];	// sequence of waits and sends for login
	int 	valtype;			// type of value (0=dial,1=xdial,2=script)
	BOOL 	qaccess;			// quick access from menu (TRUE=1, FALSE=0)
	int 	zone;				// zone for phone units (a=0, b=1, c=2, d=3)
	int 	emu;				// emulation (0=as is, 1=ansi, 2=vt100, 3=tty)
	long 	lastcall;			// c-library time(&lastcall) stamp of last call
	short	calldue;			// want call every xx days
	short	calls;				// number of calls 
	char 	memo[52];			// user memo field
	char 	password[12];		// define password for ^&
	int 	_future2[1];		// for future use, set to zero
} PHONEBOOK_098;


// =======================================================================/

// A phone book header record (might or might not be in the book (watch 
// out for the first four bytes being -1)) for internal use

typedef struct _PHONEHDR_140 {
	int hdr_id;			// always -1
	int internal[132];
} PHONEHDR_140;


// The actual phone book structure in ZOC 2.0 
// out for the first four bytes) for internal use

typedef struct _PHONEBOOK_140 {
	int 	book;				// nr of phonebook to put it in
	char	name[32+1],			// name
		 	password[24],		// define password for P
			memo[128],			// user memo field
			number[64+1],		// phone number
			script[128+1],		// name of REXX file to execute after login
			seropt[10+1],		// serial options like 38400-8N1
			optfile[64+1],		// name of options file to load
			logname[64+1],		// name of logfile to open
			waitsend[250+1],	// sequence of waits and sends for login
			username[32+1],		// name of user for IEMSI login
			scriptparm[48],		// parameter to supply for REXX call
			dlpath[48],			// download path for this host
			_future1[72];		// future use, pad with zero
	long 	lastcall;			// unix-Style time [ lastcall= time(NULL); ]
	int 	dialtype,			// index of dial prefix (0,1,2,3)
		 	zone,				// zone for phone units (a=0, b=1, ... h=7)
		 	emu,				// emulation (0=as is, 1=ansi, 2=vt100, 3=tty)
			calldue,			// want call every xx days
			calls,				// number of calls 
			totaltime,			// total online time (in seconds)
			totalmoney,			// amount spent on this bbs (cents/pennies)
			protocol,			// file transfer prot (0=xmodem, 1=y, 2=z)
			monthmoney,			// cost (cents/pennies) per month
			month,				// this month for cost
			_future2[16];		// future use, set to zero
	BOOL 	qaccess,			// quick access from menu (TRUE=1, FALSE=0)
			learn,				// learn the autologin procedure next time
			first,				// sort priority
			multimaster,		// master entry for multi line bbs
			IemsiBits,			// iemsi options bits (defaults to 0x0000003F)
			IemsiWanted,		// user wants IEMSI login?
			_future3[15];		// future use, set to zero

	int		_menuid,			// internal, set to zero
		 	_tries;				// internal, set to zero
	BOOL	_selected,			// internal, set to zero
			_todial;			// internal, set to zero
	long 	_time;				// internal, set to zero
	XRECORD	*_record;			// internal, set to zero

} PHONEBOOK_140;

#pragma pack()



// define currently up-to-date as PHONEBK
typedef PHONEBOOK_140 PHONEBOOK;
