#ifndef PIP_OK	/* Prevent multiple inclusion

/*********************************************************************/
/*                                                                   */
/*  Headerfile for PLUG-IN-PROTOCOLS (see Abstract)                  */
/*                                                                   */
/*  This file contains the necessary declarations to create          */
/*  plug in DLLs for ZOC or compatible communication packages.       */
/*                                                                   */
/*  See TECH.DOC for a more detailed description                     */
/*                                                                   */
/*                                                                   */
/*********************************************************************/
#define PIP_OK 0
#define PIP_ERROR 1

/*********************************************************************/
/*  Store your INI data under this Application-Name                  */
/*********************************************************************/
#define PIP_INIAPPL	"Zap-O-Com PIPs"


/*********************************************************************/
/*  The PIP_SOCKET describes the socket (host) application.          */
/*  Values are filled by the socket and given to all plug functions. */
/*  The plug must not modify this structure.                         */
/*********************************************************************/
typedef struct _PIP_SOCKET PIP_SOCKET;

struct _PIP_SOCKET {

	// PIP_VERSION of the socket (as defined below)
	int  PipVersion;

	// Anchor Block Handle. If zero, running a non-PM Application
	HAB  hab;

	// File handle for com device. If zero no modification of com 
	// device allowed. If nonzero the plug may use DosDevIoctls, but
	// should reset the com device to the initial state when terminating.
	HFILE hfComDevice;

	// Actual com speed. Will always be non zero.
	ULONG ulBaud;

	// Default path for up- and downloads. Must not be terminated
	// by "\". If empty ("") up-/download to current directory.
	unsigned char	szUploadDir[CCHMAXPATH],
					szDownloadDir[CCHMAXPATH];

	/************************************************/
	/* Pointers to functions, the plug may use.     */
	/************************************************/

	// output to the terminal text window (helpful for debugging purposes) 
	void (*_System ioConPutChar)(unsigned char chr);
	void (*_System ioConPutData)(unsigned char *pdata, long length);

	// query how many characters are in the input queue
	int  (*_System ioSerQueryAvail)(void);

	// Read character. If none available, PIP_READ_NODATA (256) is retured
	int  (*_System ioSerGetChar)(void);
	int  (*_System ioSerTimedGetChar)(int timeout);

	// Write single character or block of characters to com device 
	void (*_System ioSerPutChar)(unsigned char chr);
	void (*_System ioSerPutData)(unsigned char  *pdata, long length);

	// Put characters back into the input queue. Max length is 16,
	// must not be used incrementally.
	void (*_System ioSerUngetData)(unsigned char *pdata, int length);

	// Send a modem break 
	void (*_System ioSerPutBrk)(void);

	// Handle of PM frame window (eg to center upon). 
	// (Zero for VIO applications)
	HWND dlgHwndFrame;

	// Display an info or error message 
	void (*_System dlgErrorMsg)(unsigned char *txt);
	void (*_System dlgInfoMsg)(unsigned char *txt);

	// file transfer functions that know about tapping 
	FILE *	(*_System fopen)(char *name, char *mode, long size);
	int		(*_System fclose)(FILE *f);
	int		(*_System fseek)(FILE *f, int offset, int origin) ;
	long	(*_System ftell)(FILE *f);
	int		(*_System fwrite)(void *buf, int size, int num, FILE *f);
	int		(*_System fread)(void *buf, int size, int num, FILE *f);
	int		(*_System fgetc)(FILE *f);

	// Allow the socket to dispatch messages or update statusline
	// This has to be called at least once a second. Otherwise 
	// PM might hang.
	void (*_System CoreLoop)(void);

	// New for PIP Version 2.1
	void (*_System ioSerSetParm)(char *parmstring);
	void (*_System ioSerQueryParm)(char *parmstring);


	// Data for future use - don't touch that in any way.
	void *	(*_System dlgTransferWin)(int, unsigned long);
	long	__Future[29];

} ;

// Return value for ioSerGetChar if no data available (see above)
#define PIP_READ_NODATA 256


/*********************************************************************/
/*  The PIP_PLUG structure is partially filled by the plug,          */
/*  partially by the socket. It is given as the second parameter     */
/*  to every plug function (except Intro)                            */
/*********************************************************************/
typedef struct _PIP_PLUG PIP_PLUG ;

struct _PIP_PLUG {

	/* public: -------------------------------------------------------- */

	/***************************************************/
	/* Reply from pipIntro(duce yourself)              */
	/***************************************************/
	int  PlugPipVersion;		// PIP_VERSION of the plug (as defined below)
	long PlugBits;							// PIP_PBITs (see below)
	int PlugType;							// PIP_TYPE_XXX (see below)
	unsigned char PlugName[16+1];			// Short name like 'ZMODEM'
	unsigned char PlugDescription[64+1];	// Long description
	unsigned char PlugAutoUpload[32+1];		// Seq. for auto upload detection
	unsigned char PlugAutoDownload[32+1];	// Seq. for auto download detection


	/***************************************************/
	/* May be used freely from plug for private data   */
	/***************************************************/
	void *PlugPrivate;	// should be pointer to option block by convention */
	void *PlugPrivate2;
	void *PlugPrivate3;
	void *PlugPrivate4;

	/***************************************************/
	/* Handle of the plug DLL.                         */
	/* Set from socket, may be used by the plug.       */
	/***************************************************/
	HMODULE hmPlugDll;

	/* private: ------------------------------------------------------- */

	/***************************************************/
	/* Every plug needs to implement these functions   */
	/* Addresses filled in from socket upon DLL-loading*/
	/* Check PIPPLUG.C for function descriptions.      */
	/* The plug must not use these fields or make any  */
	/* assumptions about them. They are strictly for   */
	/* use by the socket!                              */
	/***************************************************/
	int (*_System pipIntro)(PIP_SOCKET*, PIP_PLUG *);
	int (*_System pipInit)(PIP_SOCKET *, PIP_PLUG *);
	int (*_System pipSetup)(PIP_SOCKET *, PIP_PLUG *);
	int (*_System pipSend)(PIP_SOCKET *, PIP_PLUG *, 
							unsigned char *single, unsigned char **multi);
	int (*_System pipReceive)(PIP_SOCKET *, PIP_PLUG *, 
							unsigned char *single, unsigned char **multi);
	int (*_System pipCleanup)(PIP_SOCKET *, PIP_PLUG *);
	int (*_System pipCustom)(PIP_SOCKET *, PIP_PLUG *);	// since V2.3


	/* public: -------------------------------------------------------- */

	char PlugCustomButton[7+1];	// Name for custom button (zero terminated) 
		

	/* private: ------------------------------------------------------- */

	/***************************************************/
	/* Data for future use - don't touch that!!        */
	/***************************************************/
	long	__Future[28];
} ;



/*********************************************************************/
/*  Set the PlugPipVersion of the _PIP_PLUG struct to PIP_VERSION    */
/*********************************************************************/
#define PIP_VERSION 0x30		/* Version 3.0 */
#define PIP_COMPATIBLE(x,y)		(((x)&0xF0)==((y)&0xF0))



/*********************************************************************/
/*  If you are doing a protocol, set PlugType to PIP_TYPE_PROTOCOL   */
/*  (other types might be available in the future)                   */
/*********************************************************************/
#define PIP_TYPE_PROTOCOL   0x0001



/*********************************************************************/
/*  Set PlugBits to a combination of these constants                 */
/*  See TECH.DOC for a discussion of possible combinations           */
/*********************************************************************/
#define PIP_PBIT_SINGLEUPLOAD		(1U<<0)
#define PIP_PBIT_MULTIPLEUPLOAD		(1U<<1)
#define PIP_PBIT_SINGLEDOWNLOAD		(1U<<2)
#define PIP_PBIT_MULTIPLEDOWNLOAD	(1U<<3)
#define PIP_PBIT_PM_OPTIONS			(1U<<4)
#define PIP_PBIT_PM_FILEREQUESTER	(1U<<5)
#define PIP_PBIT_VIO_OPTIONS		(1U<<6)
#define PIP_PBIT_VIO_FILEREQUESTER	(1U<<7)
#define PIP_PBIT_DISABLE_SETUP		(1U<<8)
#define PIP_PBIT_DISABLE_UPLOAD		(1U<<9)
#define PIP_PBIT_DISABLE_DOWNLOAD	(1U<<10)
#define PIP_PBIT_NO_SHOW_UPLOAD_REQ	(1U<<11)	// new since V2.2
#define PIP_PBIT_NO_SHOW_DNLOAD_REQ	(1U<<12)	// new since V2.2
#define PIP_PBIT_ALWAYS_8N1_XFER	(1U<<13)	// new since V2.2
#define PIP_PBIT_ENABLE_CUSTOM 		(1U<<14)	// new since V2.3



/*********************************************************************/
/*  Function prototypes for plugs.                                   */
/*  (set #define PIP_INCL_PLUG from your plug in protocol source,    */
/*  before including PIP.H)                                          */
/*********************************************************************/
#ifdef PIP_INCL_PLUG
	int _System pipIntro(PIP_SOCKET const * const, PIP_PLUG * const);
	int _System pipInit(PIP_SOCKET const * const, PIP_PLUG * const);
	int _System pipSetup(PIP_SOCKET const * const, PIP_PLUG * const);
	int _System pipSend(PIP_SOCKET const * const, PIP_PLUG * const, 
						unsigned char *, unsigned char **);
	int _System pipReceive(PIP_SOCKET const * const, PIP_PLUG * const, 
						unsigned char *, unsigned char **);
	int _System pipCleanup(PIP_SOCKET const * const, PIP_PLUG * const);
#endif	/* PIP_INCL_PLUG */

/* Socket specific stuff
#ifdef PIP_INCL_SOCKET

#endif /* PIP_INCL_SOCKET */

#endif /* PIP_OK */
