/*
 *    dlfcn::Unix dynamic loading for OS/2
 *
 * Compatibility layer for dynamic loading.
 * Only minimal implementation
 *
 * (c) 1998,1999 Yuri Dario <mc6530@mclink.it>
 *
 * $Author$
 * $Name$
 * $RCSfile$
 * $Revision$
 * $Date$
 *
 * $Log$
 *
*/

#define INCL_DOS
#include <os2.h>

char    fail[ 256];

void* dlopen( char* path, int flag)
{
   APIRET  rc;
   HMODULE hmod;

   rc = DosLoadModule( fail, sizeof( fail), path, &hmod);
   if (rc)
      return NULL;

   return (void*) hmod;
}

char* dlerror( void)
{
   return fail;
}

void* dlsym( void* hmod, char* fn)
{
   APIRET  rc;
   PFN     addr;

   rc = DosQueryProcAddr( (HMODULE) hmod, 0l, fn, &addr);
   if (rc)
      return NULL;

   return (void*) addr;
}
