/* IRC 2 startup file. Assumes Rexx is installed.
   Copyright 1994-95 V. Phaniraj -- phaniraj@badlands.nodak.edu

   This is the startup file for Irc2.exe for OS/2. It requires IBM TCP/IP 
   and OS/2 Version 2.0 and above. Various options can be setup using
   ircsetup.cmd ; some can be set by editing this file. The values in this
   file are over-ridden by command line parameters, if specified.

   C:\> IRC Nickname Server Your_name

   All parameters are optional but if omitted must be specified as 
   a dot (.). The Def_* Values above will be taken for missing or 
   specified by a dot (.) parameters. By example, if I want to
   enter irc under nickname "Try", I would type:

   C:\> IRC Try

   If I want the Default nickname but want to connect to an other server 
   I would type:

   C:\> IRC . another.server.edu

   If I want every default but my IRCNAME set to "I am God" I would type:

   C:\> IRC . . I am God  

   Change values below to suit your taste  ; others are set using 
   ircsetup.cmd. These control the colors and size of the window.
*/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

/* 
 IRCNICK   is the nickname of the user that will be used in irc
 IRCSERVER is the startup server used for irc. Find the one closest
           to you. Some examples are irc.colorado.edu, csz.bu.edu,
           irc.uiuc.edu and alfred.u.washington.edu. You can put a
           port number and passwd (if needed) on the end of the server
           by using colons as follows:
           server:port:passwd:nick
 IRCNAME   is the irc name of the user that will be shown in irc
           This information will be displayed after the username.
 USER      is the userid of the user that will be shown in irc.
 HOME      specifies the directory where the ircrc file (initialization script)
           is located.
 IRCCOLOUR this specfiies the colours used, as documented in irc2.doc
           For example changingd Def_Colour to '1F,0F,70,74,7C,47,07,07'
           would have white text on a blue background. 
 IRCLIB    this sets the location of the help, script, translation and
           ircserv.txt files.  It's calculated from the run directory of
           IRC/2 if not set.
*/

/* default just in case it's not in ini file */
IRC2_LINES=25 
IRC2_COLUMNS=80
This_ircsetup_version=3.0

'@eautil /s irc.cmd nul'
'@eautil /s ircsetup.cmd nul'

Parse source with . ThisProg .
ThisPath = left(ThisProg,Lastpos('\',ThisProg)-1)
irc_inifile = ThisPath || '\irc2.ini'

rc = stream(irc_inifile,'c','query exists')
if rc = '' Then Call 'ircsetup' irc_inifile

rc=SysIni(irc_inifile,'irc/2','ALL:','names')
do i = 1 to names.0
   val=SysIni(irc_inifile,'irc/2',names.i)
   interpret names.i '= val'
end

 No_need_to_run = 0                                                        
 if Ircsetup_version = 'IRCSETUP_VERSION' Then No_need_to_run = 1          
 else if Ircsetup_version < This_ircsetup_version Then No_need_to_run = 1  
 if No_need_to_run = 1 Then Call Ircsetup                                  


/* pick up values from the environment if they exist */

if Value('IRCNICK',,'OS2ENVIRONMENT') <> '' Then,
   Def_Nick = Value('IRCNICK',,'OS2ENVIRONMENT')

if Value('IRCSERVER',,'OS2ENVIRONMENT') <> '' Then,
   Def_Server = Value('IRCSERVER',,'OS2ENVIRONMENT')

if Value('IRCNAME',,'OS2ENVIRONMENT') <> '' Then,
   Def_Name = Value('IRCNAME',,'OS2ENVIRONMENT')

if Value('IRCLIB',,'OS2ENVIRONMENT') <> '' Then,
   Def_Lib = Value('IRCLIB',,'OS2ENVIRONMENT')

if Value('IRCPATH',,'OS2ENVIRONMENT') <> '' Then,
   Def_Path = Value('IRCPATH',,'OS2ENVIRONMENT')

if Value('IRCCOLOUR',,'OS2ENVIRONMENT') <> '' Then,
   Def_Colour = Value('IRCCOLOUR',,'OS2ENVIRONMENT')

/*
If you want to override the choice in ircsetup.cmd, move the
appropriate def_colour line to outside the comments

This is the default white on black color scheme
IRCCOLOUR = '07,0F,70,74,7C,47,07'   

This will do white text on blue background
IRCCOLOUR = '1F,0F,70,74,7C,47,1E'
*/

if Def_Colour = 'DEF_COLOUR' Then IRCCOLOUR = '07,0F,70,74,7C,47,07'   

Parse Arg Nick Server Name

if Nick   = '.' | Nick   = ' '  Then nick   = Def_Nick
if Server = '.' | Server = ' '  Then Server = Def_Server
if Name   = '.' | Name   = ' '  Then Name   = Def_Name

/*  Load Values into the environment */

call value 'IRCNICK',Nick,'OS2ENVIRONMENT'
call value 'IRCSERVER',Server,'OS2ENVIRONMENT'
call value 'IRCNAME',Name,'OS2ENVIRONMENT'
call value 'USER',Def_User,'OS2ENVIRONMENT'
call value 'HOME',Def_Home,'OS2ENVIRONMENT'
call value 'IRCLIB',Def_Lib,'OS2ENVIRONMENT'
call value 'IRCPATH',Def_Path,'OS2ENVIRONMENT'
call value 'IRCCOLOUR',Def_Colour,'OS2ENVIRONMENT'

'@mode co'IRC2_COLUMNS','IRC2_LINES

errfile = SysTempFileName(ThisPath'\irc2err.???')
'@if exist' ThisPath'\rawlog.tx4 del' ThisPath'\rawlog.tx4 > NUL'
'@if exist' ThisPath'\rawlog.tx3 ren' ThisPath'\rawlog.tx3' 'rawlog.tx4 > NUL'
'@if exist' ThisPath'\rawlog.tx2 ren' ThisPath'\rawlog.tx2' 'rawlog.tx3 > NUL'
'@if exist' ThisPath'\rawlog.tx1 ren' ThisPath'\rawlog.tx1' 'rawlog.tx2 > NUL'
'@if exist' ThisPath'\rawlog.txt ren' ThisPath'\rawlog.txt' 'rawlog.tx1 > NUL'

irc_exe_file = ThisPath || '\irc2.exe'
start = date(U) time()
rc = SysFileTree(irc_exe_file, file_list)

if file_list.0 = 0 then 
 Do
  say  'The irc2.exe file was not found. Please check the directory'
  say  'in which Irc/2 was installed.'
  rc=SysSleep(2)
  Exit
 End

xx=pos('&',Def_Parms)
if xx <>0 then Def_Parms=insert('^',Def_Parms,xx-1)
xx1=pos('&',Def_Parms)
if xx1 > xx+1 then Def_Parms=insert('^',Def_Parms,xx1-1)
xx2=pos('&',Def_Parms)
if xx2>xx1+1 then Def_Parms=insert('^',Def_Parms,xx2-1)

'@'irc_exe_file Def_Parms '2>' errfile

errfilesize = stream(errfile,C,'query size')
if errfilesize <> 0 Then 
Do
   '@type' errfile ' >> irc2err.dat'

   mailfile = SysTempFileName(ThisPath'\tempmail.???')
   logfile = ThisPath'\rawlog.txt'

   rc = lineout(mailfile, 'Subject: IRC/2 v0.40 Crash')
   rc = lineout(mailfile, '')
   rc = lineout(mailfile, 'Session started' start)
   rc = lineout(mailfile, '')
   rc = lineout(mailfile, 'Crashed at' date(U) time())
   rc = lineout(mailfile, '')
   rc=stream(mailfile, 'c', 'close');

   '@type' errfile '>>' mailfile

   say ''
   say 'IRC/2 has exited with an error condition.  Information regarding this error'
   say 'will automatically be mailed to <irc2bugs@invlogic.com> so we may explore'
   say 'the cause of this problem, and fix it for our next release.  Sendmail will'
   say 'be run shortly to assist in this process.'
   say ''
  
   etc=translate(value('ETC',,'OS2ENVIRONMENT'))
   parse var etc root'\ETC'
   umail=root||'\UMAIL'

   cfg=stream(etc'\sendmail.cf', 'C', 'Q EXISTS')
   if cfg = '' then do
      cfg = stream(etc'\sendmail.uml', 'C', 'Q EXISTS')
      if cfg <> '' then do
         parse var def_emailname userid '@' node

         if def_emailname="DEF_EMAILNAME" then do

            inputfile = umail'\umail.pro'
            fname=stream(inputfile,'C','Q EXISTS')
            If fname<>'' Then Do
               rc=stream(inputfile,'c','open read')
               k=0;
               do forever
                  inline=linein(inputfile)
                  if inline= '' then leave

                  parse var inline . ':USER' The_rest
                  if length(The_rest)<>0 Then Do
                     parse var The_rest . '=' "'"userid"'"
                     do forever
                        inline=linein(inputfile)
                        if inline= '' then leave

                        parse var inline . 'reply_domain' The_rest
 
                        if length(The_rest)<>0 Then Do
                           parse var The_rest . '=' "'"node"'"
                           Leave
                        End
                     end
                     leave
                  End
               end 
               rc=stream(inputfile, 'c', 'close');
            End
         End
  
         if (userid = "USERID") | (node = "NODE") then
            call fail
         else do
            '@sendmail -f'userid '-C'etc'\sendmail.uml -oMVrouter.invlogic.com -oMH'node 'irc2bugs@invlogic.com > nul <' mailfile
            '@del' mailfile '> NUL'
         end  /* Do */
      end
      else 
         call fail
   end  
   else do
       mailfile2 = SysTempFileName(ThisPath'\tempmail.???')
       rc = lineout(mailfile2, 'From: "'Def_name'" <'Def_User'>')
       rc = lineout(mailfile2, 'Reply-to: ' Def_Emailname)
       rc=stream(mailfile2, 'c', 'close');
       '@type' mailfile '>>' mailfile2
      '@sendmail -f ' Def_Emailname  '-t irc2bugs@invlogic.com > nul <' mailfile2
      '@del' mailfile2 '> NUL'
      '@del' mailfile '> NUL'
   end
End

'@del' errfile '> NUL'

Exit 0

fail: procedure
   say 'Unable to send error message to <irc2bugs@invlogic.com> because no valid'
   say 'sendmail configuration could be found to use.  Please take whatever steps'
   say 'are necessary to email the file' mailfile 'to the address shown above'
   say 'With your help, we can make IRC/2 a better program'
   '@pause'

   return
