/* test1.c */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <db.h>

struct rec
{
  int n;
};


static void add (DB *db, int n)
{
  recno_t key;
  struct rec data;
  DBT dbt_key, dbt_data;

  key = n; data.n = n;
  dbt_key.data = &key; dbt_key.size = sizeof (key);
  dbt_data.data = &data; dbt_data.size = sizeof (data);
  if (db->put (db, &dbt_key, &dbt_data, 0) != 0)
    {
      perror ("db->put()");
      exit (2);
    }
}


static int seq (DB *db, int flags)
{
  DBT dbt_key, dbt_data;
  int rc;

  memset (&dbt_key, 0, sizeof (dbt_key));
  memset (&dbt_data, 0, sizeof (dbt_data));

  rc = db->seq (db, &dbt_key, &dbt_data, flags);
  if (rc < 0)
    {
      perror ("db->seq()");
      exit (2);
    }

  if (rc > 0)
    return (0);

  printf ("%d -> %d\n", *(recno_t *)dbt_key.data,
          ((struct rec *)dbt_data.data)->n);
  return (1);
}


int main (int argc, char *argv[])
{
  RECNOINFO info;
  DB *db;
  int i;

  info.bval = 0;
  info.cachesize = 0;
  info.psize = 0;
  info.flags = R_FIXEDLEN;
  info.lorder = 0;
  info.reclen = sizeof (struct rec);
  info.bfname = NULL;

  db = dbopen (NULL, O_CREAT | O_RDWR, S_IREAD | S_IWRITE, DB_RECNO, &info);
  if (db == NULL)
    {
      perror ("dbopen()");
      exit (2);
    }

  add (db, 5);
  add (db, 2);
  add (db, 3);
  add (db, 1);
  add (db, 4);
  add (db, 7);

  if (seq (db, R_FIRST))
    while (seq (db, R_NEXT))
      ;

  if (db->close (db) != 0)
    {
      perror ("db->close()");
      exit (2);
    }
  return (0);
}
