#ifndef _WINDOW_H_
#define _WINDOW_H_

#define INCL_PM
#include <objc/os2.h>
#include <objc/Object.h>

#define WINDOW_CLASS "ObjcWindow"

@interface Window : Object
{
  HWND    window;

  Window *child;
  Window *sibling;
}

// initializers and destructors
- init;
- associate: (HWND) hwnd;
- free;

// methods concerning window hierarchy
- createObjects;
- insertChild: aChild;
- insertSibling: aSibling;
- findFromID: (ULONG) anId;
- findFromHWND: (HWND) aHwnd;

// methods for access to window words
- (char *) text: (char *) buffer;
- (int) textLength;
- setText: (const char *) buffer;
- setSize: (LONG) x : (LONG) y : (LONG) w : (LONG) h;
- setRect: (LONG) w : (LONG) h;
- size: (PSWP) aSize;
- (LONG) width;   // width of window
- (LONG) height;  // height of window
- (LONG) xoffset; // horizontal offset of lower left corner
- (LONG) yoffset; // vertical offset of lower left corner

// methods for access to instance variables
- (HWND) window;
- (ULONG) pmId;

// methods for access to PM messages
- enable;     // enable window
- disable;    // disable window
- activate;   // activate window
- deactivate; // deactivate window

// methods for controlling display behaviour of windows
- invalidate; // invalidate whole window rect
- show;       // show window
- hide;       // hide window

// message loop
- (MRESULT) handleMessage: (ULONG) msg
            withParams: (MPARAM) mp1 and: (MPARAM) mp2;

@end

MRESULT EXPENTRY __windowFunction (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

#endif
