@echo off
rem *--------------------------------------------------------------------------*
rem * This batch file should be run to create gpp.a, gpp_p.a and gpp290xx.a
rem * libraries. Because GNU C++ compiler with frame-unwind-info exceptions
rem * requires a slightly different initialization, it has its own gcc-specific
rem * runtime. If you link with gcc rather than with g++ you will get slightly
rem * smaller (5-10K) executables because no extra data and code will be linked
rem * against code that do not require stack frame unwind info.
rem *--------------------------------------------------------------------------*

 rem *** Set the following to base path of PGCC source tree
 set pgccpath=/src/gcc/pgcc-2.95.3/gcc/
 set pgccver=2952

 if not exist gcc.a   goto nogcclib
 if not exist gcc_p.a goto nogcclib

 if not exist %pgccpath%libgcc2.c goto nogccpath

 if not exist st mkdir st
 if not exist mt mkdir mt

 rem *** First build the "no exception" version of
 rem *** constructor/destructor initializer routine

 copy gcc.a gpp.a >nul
 copy gcc_p.a gpp_p.a >nul

 echo Compiling constructor/destructor initializer routine for C
 gcc -s  -c -O6 -D__NO_CPLUSPLUS__ %pgccpath%config/i386/emx-ctordtor.c -o emx-ctordtor.o
 if errorlevel 1 goto error
 ar r gcc.a emx-ctordtor.o
 echo Compiling constructor/destructor initializer routine for C with profiling
 gcc -pg -c -O6 -D__NO_CPLUSPLUS__ %pgccpath%config/i386/emx-ctordtor.c -o emx-ctordtor.o
 if errorlevel 1 goto error
 ar r gcc_p.a emx-ctordtor.o

 copy gcc.a st >nul
 copy gcc_p.a st >nul
 copy gpp.a st >nul
 copy gpp_p.a st >nul

 rem *** Now build multithreaded versions of libgcc
 rem *** Default build process creates single threaded version of libgcc

 set libgcc_cflags=-mprobe -mepilogue -Zmt
 set libgcc_def=-DIN_GCC -DNDEBUG -DHAVE_GTHR_DEFAULT -D__GTHREADS -D_OS2_THREADS -DIN_LIBGCC2 -D__GCC_FLOAT_NOT_NEEDED
 set libgcc_inc=-I%pgccpath% -I%pgccpath%include -I%pgccpath%../include -I%pgccpath%config

 echo Compiling multithreaded exception handler routine
 gcc -s -c -O6 -fexceptions %libgcc_cflags% %libgcc_inc% %libgcc_def% -DL_eh %pgccpath%libgcc2.c -o _eh.o
 if errorlevel 1 goto error
 ar r gcc.a _eh.o
 ar r gpp.a _eh.o
 echo Compiling multithreaded exception handler routine with profiling
 gcc -pg -c -O6 -fexceptions %libgcc_cflags% %libgcc_inc% %libgcc_def% -DL_eh %pgccpath%libgcc2.c -o _eh.o
 if errorlevel 1 goto error
 ar r gcc_p.a _eh.o
 ar r gpp_p.a _eh.o

 echo Compiling multithreaded frame unwind routine
 gcc -s -c -O6 %libgcc_cflags% %libgcc_inc% %libgcc_def% %pgccpath%frame.c -o frame.o
 if errorlevel 1 goto error
 ar r gcc.a frame.o
 ar r gpp.a frame.o
 echo Compiling multithreaded frame unwind routine with profiling
 gcc -pg -c -O6 %libgcc_cflags% %libgcc_inc% %libgcc_def% %pgccpath%frame.c -o frame.o
 if errorlevel 1 goto error
 ar r gcc_p.a frame.o
 ar r gpp_p.a frame.o

 del mt\gcc*.a >nul 2>nul
 move gcc.a mt >nul
 move gcc_p.a mt >nul
 del mt\gpp*.a >nul 2>nul
 move gpp.a mt >nul
 move gpp_p.a mt >nul

 del *.o >nul 2>nul

 echo Creating dynamic library from libgcc
 call dllar st/gpp.a -o gcc%pgccver%s -ordinal -nocrtdll -ex "__main __do_global_* _GLOBAL* _exit_dummy_ref __ctordtor*" -d "GNU C runtime shared library version %pgccver%" -libf "INITINSTANCE TERMGLOBAL" -lc_static -lc_import
 if errorlevel 1 goto error
 del gcc_dll* 2>nul
 ren gcc%pgccver%s.a gcc_dll.a
 ar x st/gpp.a __main.o emx-ctordtor.o
 ar r gcc_dll.a __main.o emx-ctordtor.o
 del __main.o emx-ctordtor.o
 ranlib gcc_dll.a
 move gcc_dll.a st >nul

 echo Creating dynamic library from multithreaded libgcc
 call dllar mt/gpp.a -o gcc%pgccver%m -Zmt -ordinal -nocrtdll -ex "__main __do_global_* _GLOBAL* _exit_dummy_ref __ctordtor*" -d "GNU C runtime shared library version %pgccver%" -libf "INITINSTANCE TERMGLOBAL" -lc_static -lc_import
 if errorlevel 1 goto error
 del gcc_dll* 2>nul
 ren gcc%pgccver%m.a gcc_dll.a
 ar x mt/gpp.a __main.o emx-ctordtor.o
 ar r gcc_dll.a __main.o emx-ctordtor.o
 del __main.o emx-ctordtor.o
 ranlib gcc_dll.a
 move gcc_dll.a mt >nul

 echo All done

exit

:error
 echo An unknown error occured during build process
 echo Try to investigate what happened and fix it
exit

:nogcclib
 echo You should put gcc.a and gcc_p.a into current directory
 echo prior to running this batch file!
exit

:nogccpath
 echo You should set up correctly the "pgccpath" variable
 echo at the beginning of this batch file!
exit
