/* Threads compatibily routines for libgcc2.  */
/* Compile this one with gcc.  */
/* Copyright (C) 1997 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with other files,
   some of which are compiled with GCC, to produce an executable,
   this library does not by itself cause the resulting executable
   to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#ifndef __gthr_os2_h
#define __gthr_os2_h

/* The __MT__ symbol should be defined for multiple threads (-Zmt) */
#ifdef __MT__

/* OS/2 threads specific definitions */

#include <sys/builtin.h>
#include <sys/smutex.h>
#include <malloc.h>
#include <stdlib.h>

typedef volatile unsigned char __gthread_key_t;
typedef volatile _smutex __gthread_once_t;
typedef volatile _smutex __gthread_mutex_t;

#define __GTHREAD_MUTEX_INIT	0
#define __GTHREAD_ONCE_INIT	0

static volatile int threadstore_bitmap = 0;
static __gthread_once_t threadstore_initialized = __GTHREAD_ONCE_INIT;

static inline int
__gthread_active_p ()
{
  return 1;
}

static inline int
__gthread_once (__gthread_once_t *once, void (*func) ())
{
  if (__cxchg (once, 1) == 0)
    func ();
  return 0;
}

static inline void
__threadstore_initialize ()
{
  *_threadstore () = malloc (32 * sizeof (void *));
}

// LIMIT: can create max 32 __gthread_key_t's
static inline int
__gthread_key_create (__gthread_key_t *key, void (*dtor) (void *))
{
  __gthread_once (&threadstore_initialized, __threadstore_initialize);
  *key = __fls (threadstore_bitmap) - 1;
  return (*key == (unsigned char)(-1 - 1));
}

static inline int
__gthread_key_dtor (__gthread_key_t key, void *ptr)
{
  /* Just reset the key value to zero. */
  if (ptr)
  {
    ((const void **)*_threadstore ()) [key] = 0;
    return 0;
  }
  else
    return 0;
}

static inline int
__gthread_key_delete (__gthread_key_t key)
{
  threadstore_bitmap &= ~(1 << key);
  return 0;
}

static inline void *
__gthread_getspecific (__gthread_key_t key)
{
  return ((void **)*_threadstore ()) [key];
}

static inline int
__gthread_setspecific (__gthread_key_t key, const void *ptr)
{
  ((const void **)*_threadstore ()) [key] = ptr;
  return 0;
}

static inline int
__gthread_mutex_lock (__gthread_mutex_t *mutex)
{
  _smutex_request (mutex);
  return 0;
}

static inline int
__gthread_mutex_trylock (__gthread_mutex_t *mutex)
{
  return __cxchg (mutex, 1);
}

static inline int
__gthread_mutex_unlock (__gthread_mutex_t *mutex)
{
  _smutex_release (mutex);
  return 0;
}

#else /* __MT__ */

#include "gthr-single.h"

#endif /* __MT__ */

#endif /* not __gthr_os2_h */
