/* tm.h for emx */

#define EMX
#define NAMES_HAVE_UNDERSCORE
#define FLOAT_INFO i386_float_info()

/* longjmp() */

#define JB_ELEMENT_SIZE 4
#define JB_PC           5

extern int
get_longjmp_target PARAMS ((CORE_ADDR *));

#define GET_LONGJMP_TARGET(ADDR) get_longjmp_target(ADDR)

/* Used for signal handlers under OS/2. */

#define EXTRA_FRAME_INFO \
  struct frame_saved_regs *fsr ;	\
  CORE_ADDR sig_prev_frame;

#define INIT_EXTRA_FRAME_INFO(fromleaf, fi) \
	emx_init_extra_frame_info (fromleaf, fi)
struct frame_info;
extern void emx_init_extra_frame_info (int, struct frame_info *);

#include "i386/tm-i386v.h"

#undef FRAME_CHAIN
#define FRAME_CHAIN(thisframe)  \
  ((thisframe)->signal_handler_caller \
   ? (thisframe)-> sig_prev_frame \
   : ((((thisframe)->pc & 0xffff) == 12 + 5 \
       || !inside_entry_file ((thisframe)->pc)) \
      ? read_memory_integer ((thisframe)->frame, 4) \
      : 0))

#undef  FRAME_SAVED_PC
#define FRAME_SAVED_PC(FRAME) \
  (read_memory_integer ((FRAME)->fsr ? (FRAME)->fsr->regs[PC_REGNUM] \
                        : (FRAME)->frame + 4, 4))

#define FRAME_CHAIN_VALID(chain, thisframe) \
  emx_frame_chain_valid (chain, thisframe)
extern int emx_frame_chain_valid (CORE_ADDR, struct frame_info *);
