/* inst.cmd */

languages = 'cp f gnat'
version = '2.8.1'
dir = 'gcc-2.8'
boundschecking = 1
shortnames = 1
bcversion = '2.8.1-1.01'
patch = 'lwpatch'

call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'
call RxFuncAdd 'SysSleep',      'RexxUtil', 'SysSleep'

progs = 'gzip mv rm sed tar touch' patch
do i = 1 to words(progs)
  prog = word(progs, i)||'.exe'
  path = SysSearchPath('PATH', prog)
  if path == '' then
    error('Program not found: '||prog)
end
/* TODO: improve the test for OS/2's PATCH.EXE */
path = SysSearchPath('PATH', patch||'.exe')
if translate(filespec('p', path)) == '\OS2\' then
  error('Cannot use OS/2 version of PATCH.EXE')

call defval 'bc', boundschecking
call defval 'sn', shortnames

usage = 0
parse arg cmdline
do forever
  parse var cmdline opt rest
  if left(opt, 1) \== '-' then leave
  if opt == '-b' then
    boundschecking = 1
  else if opt == '-nb' then
    boundschecking = 0
  else if opt == '-s' then
    shortnames = 1
  else if opt == '-l' then
    shortnames = 0
  else do
    say 'Unknown option:' opt
    usage = 1
    leave
  end
  cmdline = rest
end

parse var cmdline first last rest

if first == '' then first = 1
if last == '' then last = 9999

if usage | (rest \== '') | \datatype(first,'n') | \datatype(last,'n'),
   | (first > last) then do
  say 'Usage: inst [<options>] [<start#> [<end#>]]'
  say 'Options:'
  say '  -b  Include bounds checking' bc.on
  say '  -nb Don''t include bounds checking' bc.off
  say '  -l  Use long file names' sn.off
  say '  -s  Use short file names' sn.on
  usage = 1
end

if \exists('patches\gcc\makefile.sed') then
  error('The current working directory must be \emx\gnu')

'@echo off'

if usage then say 'Values for <start#> and <end#>:'

if step(1, 'Unpacking GCC') then do
  if exists(dir) | dir_exists(dir) then error(dir||' exists')
  'tar xzf gcc-'||version||'.tar.gz'
  if rc \== 0 then error('tar failed')
end

if step(2, 'Renaming directory and removing read-only flag') then do
  'ren gcc-'||version dir
  if rc \== 0 then error('ren failed')
  'attrib -r '||dir||'\* /s'
  if rc \== 0 then error('attrib failed')
end

if step(3, 'Unpacking bounds checking code') then do
  if boundschecking then do
    'cd' dir
    'tar xzf ..\bounds-checking-'||bcversion||'.tar.gz'
    if rc \== 0 then error('tar failed')
    'cd ..'
  end
  else say '  (bounds checking is disabled)'
end

if step(4, 'Deleting unused files') then do
  'cd' dir
  'rm build-make config.guess config.sub configure configure.bat'
  'rm configure.frag configure.in configure.lang cross-make dostage2'
  'rm dostage3 fixcpp fixinc* fixproto genmultilib install.sh just-fixinc'
  'rm listing move-if-change scan-types.sh sort-protos *.com'
  'rm cp/make-lang.in cp/config-lang.in cp/mpw-config.in'
  'rm ChangeLog* gcc.info* cpp.info* *.fns *.cps'
  'rm ORDERS PROBLEMS PROJECTS README* SERVICE TAGS TESTS.FLUNK INSTALL'
  'rm cpp.1 cccp.1 gcc.1 gcc.hlp cp/g++.1 future.options aclocal.m4'
  'rm cp/ChangeLog* cp/mpw-make.sed'
  'rm mips* ginclude/math-*.h ginclude/proto.h'
  'rm alloca.c assert.h collect2.c crtstuff.c dbxstclass.h doschk.c'
  'rm enquire.c fix-header.c floatlib.c gbl-ctors.h'
  'rm gen-protos.c getopt.c getopt.h getopt1.c glimits.h gmon.c'
  'rm gsyslimits.h halfpic.c halfpic.h libgcc1.c libgcc1-test.c'
  'rm limitx.h limity.h longlong.h protoize.c pself*.c scan.c'
  'rm scan.h scan-decls.c sys-protos.h sys-types.h unprotoize.c'
  'cd config'
  'rm -r 1750a a29k alpha arc arm clipper convex dsp16xx'
  'rm -r elxsi fx80 gmicro h8300 i370 i860 i960 m32r m68k'
  'rm -r m88k mips mn10200 mn10300 msdos ns32k pa pdp11'
  'rm -r pyr romp rs6000 sh sparc spur tahoe vax v850'
  'rm -r we32k winnt'
  'rm README aoutos.h dbx*.h fp-bit.c float*.h gnu.h gofast.h'
  'rm libgloss.h linux*.h lynx*.h netbsd.h nextstep.* nextstep21.h'
  'rm psos.h ptx4.h svr3.h svr4.h'
  'rm t-gnu t-libc-ok t-linux* t-rtems t-svr4 t-netbsd'
  'rm x-linux* x-lynx xm-gnu.h xm-linux.h xm-lynx.h x-svr4 xm-svr3.h xm-svr4.h'
  'cd i386'
  'rm aix*.h 386bsd.h att.h bsd386.h cygwin32.h dgux.h freebsd*.h'
  'rm gnu.h go32*.h i386-coff.h isc*.h linux*.h lynx*.h mach.h'
  'rm mingw32.h moss.h next.h netbsd.h os2.h osfrose.h perform.h'
  'rm sco*.h sol2.h osfelf.h ptx4-i.h rtems.h seq*.h sol2dbg.h'
  'rm sun*.h svr3*.h sysv3.h sysv4.h v3gas.h vsta.h win-nt.h'
  'rm xm-aix.h xm-dos.h xm-bsd386.h xm-cygwin32.h xm-dgux.h xm-gnu.h'
  'rm xm-go32.h xm-isc.h xm-linux.h xm-lynx.h xm-mingw32.h xm-next.h'
  'rm xm-os2.h xm-osf.h xm-sco*.h xm-vsta.h xm-winnt.h'
  'rm xm-sun.h xm-sysv3.h xm-sysv4.h'
  'rm winnt.c dgux.c gmon-sol2.c'
  'rm config-nt.sed cygwin32.asm sol2*.asm svr3.ifile svr3z.ifile'
  'rm t-crtpic t-crtstuff t-cygwin32 t-dgux t-freebsd t-go32'
  'rm t-i386bare t-osf t-sco5 t-vsta t-winnt t-next t-sol2 t-svr3dbx'
  'rm x-aix x-cygwin32 x-dgux x-isc* x-ncr3000 x-next x-osfrose x-sco*'
  'rm x-sysv3 x-vsta'
  'cd ..\..\..'
end

if step(5, 'Applying bounds checking patches') then do
  if boundschecking then do
    'cd' dir
    'ren bounds-checking.diff bounds-checking.diff.orig'
    'sed -f ..\patches\gcc\bounds1.sed bounds-checking.diff.orig >tmp'
    'sed -f ..\patches\gcc\bounds2.sed tmp >bounds-checking.diff'
    patch '-p1 <bounds-checking.diff'
    'rm c-parse.c c-parse.h objc\objc-parse.c cp\parse.c cp\parse.h'
    'cd ..'
  end
  else say '  (bounds checking is disabled)'
end

if step(6, 'Renaming files to 8.3') then do
  if shortnames then do
    'cd' dir
    /* source files */
    call renameshort 'basic-block.h'
    call renameshort 'bc-typecd.h'
    call renameshort 'bc-typecd.def'
    call renameshort 'bi-opcode.c'
    call renameshort 'bi-opname.c'
    call renameshort 'bi-parser.h'
    call renameshort 'bi-parser.y'
    call renameshort 'bi-parser.c'
    call renameshort 'bi-reverse.c'
    call renameshort 'bytetypes.h'
    call renameshort 'caller-save.c'
    call renameshort 'c-aux-info.c'
    call renameshort 'c-convert.c'
    call renameshort 'c-iterate.c'
    call renameshort 'c-parse.gperf'
    call renameshort 'choose-temp.c'
    call renameshort 'conditions.h'
    call renameshort 'cplus-dem.c'
    call renameshort 'dwarf2out.c'
    call renameshort 'fold-const.c'
    call renameshort 'gansidecl.h'
    call renameshort 'genconfig.c'
    call renameshort 'genattrtab.c'
    call renameshort 'genextract.c'
    call renameshort 'genopinit.c'
    call renameshort 'genoutput.c'
    call renameshort 'hard-reg-set.h'
    call renameshort 'integrate.c'
    call renameshort 'integrate.h'
    call renameshort 'local-alloc.c'
    call renameshort 'print-rtl.c'
    call renameshort 'print-tree.c'
    call renameshort 'reg-stack.c'
    call renameshort 'stor-layout.c'
    call renameshort 'typeclass.h'
    call renameshort 'cp\exception.cc'
    call renameshort 'cp\gxx.gperf'
    call renameshort 'cp\g++spec.c'
    /* documentation files */
    call renameshort 'cpp.texi'
    call renameshort 'extend.texi'
    call renameshort 'gcc.texi'
    call renameshort 'gcov.texi'
    call renameshort 'install.texi'
    call renameshort 'invoke.texi'
    call renameshort 'md.texi'
    call renameshort 'rtl.texi'
    call renameshort 'tm.texi'
    call renameshort 'cp\g++FAQ.texi'
    call renameshort 'cp\gxxint.texi'
    call renameshort 'cp\lang-options.h'
    call renameshort 'cp\lang-specs.h'
    if \boundschecking then  /* otherwise it doesn't exist */
      call renameshort 'objc\objc-parse.c'
    call renameshort 'objc\Make-lang.in'
    call renameshort 'objc\nil_method.c'
    call renameshort 'objc\objc.gperf'
    call renameshort 'objc\objc-list.h'
    call renameshort 'objc\objc-parse.y'
    call renameshort 'objc\objc-tree.def'
    call renameshort 'objc\thr-single.c'
    call renameshort 'objc\typedstream.h'
    call renameshort 'objc\NXConstStr.h'
    call renameshort 'objc\NXConstStr.m'
    /* other files */
    call renameshort '.gdbinit'
    /* bounds checking */
    if boundschecking then do
      call renameshort 'bounds-checking.diff'
      call renameshort 'bounds\lib\exstatics.c'
      call renameshort 'bounds\lib\bounds-lib.h'
      call renameshort 'bounds\lib\functions.c'
      call renameshort 'bounds\lib\functions.h'
      call renameshort 'bounds\lib\malloc\getpagesize.h'
      call renameshort 'bounds\lib\malloc\mem-limits.h'
    end
    'cd ..'
  end
end

if step(7, 'Configuring for emx') then do
  'cd' dir
  'copy ..\patches\gcc\tm.h >nul'
  'copy ..\patches\gcc\config.h >nul'
  'copy ..\patches\gcc\config.h hconfig.h >nul'
  'copy ..\patches\gcc\emx.c config\i386 >nul'
  'copy ..\patches\gcc\emx.h config\i386 >nul'
  'copy ..\patches\gcc\xm-emx.h config\i386 >nul'
  'touch c-gperf.h'
  if boundschecking then do
    /* bounds-checking.diff changes c-parse.in! */
    'touch objc\'||truncate('objc-parse.y')
    'touch c-parse.y'
    'copy ..\patches\gcc\make.cmd bounds\lib >nul'
  end
  else
    'touch cp\parse.c cp\parse.h'
  'copy ..\patches\gcc\dostage1.cmd >nul'
  'copy ..\patches\gcc\dostage2.cmd >nul'
  'copy ..\patches\gcc\dostage3.cmd >nul'
  'copy ..\patches\gcc\makeexe.cmd >nul'
  'copy ..\patches\gcc\movstage.cmd >nul'
  'copy ..\patches\gcc\compile.cmd >nul'
  'copy ..\patches\gcc\3stages.cmd >nul'
  'copy ..\patches\gcc\multilib.h >nul'
  call patchshort '..\patches\gcc\objc.mak', 'objc\makefile'
  'copy ..\patches\gcc\tconfig.h >nul'
  'sed -n -f ..\patches\gcc\version.sed version.c >version.sed'
  'sed -n -f ..\patches\gcc\mversion.sed version.c >mversion.sed'
  'sed -f ..\patches\gcc\make-obj.sed objc\'||truncate('Make-lang.in')||' >make-obj.tmp'
  'sed -f ..\patches\gcc\fragment.sed Makefile.in >tmp1'
  'sed -f ..\patches\gcc\makefile.sed -f ..\patches\gcc\make-c.sed -f version.sed -f mversion.sed tmp1 >tmp2'
  call patchshort 'tmp2', 'Makefile'
  'sed -f ..\patches\gcc\makefile.sed -f ..\patches\gcc\make-cp.sed cp\Makefile.in >tmp'
  call patchshort 'tmp', 'cp\Makefile'
  call patchshort '..\patches\gcc\objs-cp', 'cp\objs'
  if boundschecking then do
    'sed -f ..\patches\gcc\bounds3.sed bounds\lib\Makefile >tmp'
    call patchshort 'tmp', 'bounds\lib\Makefile'
    'sed -f ..\patches\gcc\malloc.sed bounds\lib\malloc\Makefile >tmp'
    call patchshort 'tmp', 'bounds\lib\malloc\Makefile'
  end
  'rm -f specs.h options.h'
  specs = ''
  options = ''
  lo = truncate('lang-options.h')
  ls = truncate('lang-specs.h')
  do i = 1 to words(languages)
    lang = word(languages, i)
    llo = lang||'\'||lo
    lls = lang||'\'||ls
    if exists('..\patches\gcc\'||lang||'.opt'),
     & exists('..\patches\gcc\'||lang||'.spe'),
     & \exists(llo) & \exists(lls) then do
     if \dir_exists(lang) then 'mkdir' lang
     'copy ..\patches\gcc\'||lang||'.opt '||llo||' >nul'
     'copy ..\patches\gcc\'||lang||'.spe '||lls||' >nul'
    end
    if exists(llo) & exists(lls) then do
      specs = specs lang||'/'||ls
      options = options lang||'/'||lo
      'echo #include "'||lang||'/lang-specs.h">>specs.h'
      'echo #include "'||lang||'/lang-options.h">>options.h'
    end
  end
  'sed -e "s!@lang_specs_files@!'||space(specs)||'!" Makefile >tmp1'
  'sed -e "s!@lang_options_files@!'||space(options)||'!" tmp1 >tmp2'
  'mv tmp2 Makefile'
  'rm version.sed mversion.sed make-obj.tmp tmp tmp1'
  'touch' truncate('config.status')
  call SysSleep 2
  'touch multilib.h'
  'cd ..'
end

if step(8, 'Applying emx patches') then do
  'cd' dir
  if \boundschecking then do
    'sed -f ..\patches\gcc\bounds1.sed ..\patches\gcc\patches >tmp1'
    'sed -f ..\patches\gcc\bounds4.sed tmp1 >tmp2'
  end
  else
    'copy ..\patches\gcc\patches tmp2 >nul'
  if shortnames then
    patch '-p1 <tmp2'
  else do
    'sed -f ..\patches\gcc\longdiff.sed tmp2 >tmp1'
    patch '-p1 <tmp1'
  end
  if \boundschecking then do
    'sed -f ..\patches\gcc\bounds5.sed gcc.c >tmp1'
    'mv tmp1 gcc.c'
  end
  'rm -f tmp1 tmp2'
  'cd ..'
end

if \usage then do
  'cd' dir
  'dir *.rej /s /f 2>nul'
  'cd ..'
end

exit usage

/* Procedures */

exists:
  return stream(arg(1), 'c', 'query exists') \== ''

dir_exists: procedure
  cur = directory()
  new = directory(arg(1))
  call directory(cur)
  return new \= ''
  
step: procedure expose first last usage
  if usage then do
    say '  ' arg(1)||':' arg(2)
    return 0
  end
  if (first <= arg(1)) & (arg(1) <= last) then do
    say 'Step' arg(1)||':' arg(2)
    return 1
  end
  return 0

error:
  say '*** Error:' arg(1)
  exit 2

renameshort:
  'ren' arg(1) truncate(filespec('n', arg(1)))
  return

patchshort:
  if shortnames then
    'sed -f ..\patches\gcc\rename.sed' arg(1) '>'||arg(2)
  else
    'copy' arg(1) arg(2) '>nul'
  return

truncate: procedure expose shortnames
  if \shortnames then
    return arg(1)
  name = translate(arg(1), 'p', '+')
  if left(name, 1) == '.' then
    name = '!'||substr(name, 2)
  if pos('.',name) == 0 then
    return delstr(name,8+1)
  parse var name base'.'ext
  return delstr(base,8+1)||'.'||delstr(ext,3+1)

defval:
  call value arg(1)||'.on', word('[default]', 2-arg(2))
  call value arg(1)||'.off', word('[default]', 1+arg(2))
  return
