/* gettid.c -  replaces gettid() call in the emx library

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <emx/syscalls.h>
#include <stdlib.h>

#define WIN32_LEAN_AND_MEAN
#include <wingnuc.h>
#include <windows.h>

extern __inline__ int is_rsxnt_loaded()
{
#define RUN_RSX 0x1000
    if (_emx_env & RUN_RSX) {
        if ((_emx_rev >> 16) == 2)  /* RSXNT */
            return 1;
    }
    return 0;
}

int __rsxntfix_threadid(void)
{
    if (!is_rsxnt_loaded())
        return 1;
    else
        return GetCurrentThreadId();
}
