/* port.h - defines for linux or djgpp gcc

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#ifndef _PORT_H
#define _PORT_H

#ifdef __linux__

#define O_BINARY 0

#define tell(fd)            lseek(fd, 0, SEEK_CUR)
#define chsize(handle, ptr) ftruncate(handle, ptr)
#define stricmp             strcasecmp

long    filelength (int fd);
int     strlwr(char *);
int     strupr(char *);

#else /* EMX, DJGPP */

#include <io.h>

#endif /* not __linux__ */

#if !defined (_MAX_PATH)
#define _MAX_PATH   260
#define _MAX_DRIVE    3
#define _MAX_DIR    256
#define _MAX_FNAME  256
#define _MAX_EXT    256
#endif

#include <stdio.h>
int     _path (char *dst, const char *name);
int     _abspath (char *dst, const char *src, int size);
void    _splitpath (const char *src, char *drive, char *dir, char *fname, char *ext);
char *  _strncpy (char *string1, const char *string2, size_t size);
FILE *  _fsopen (const char *fname, const char *mode, int shflag);
void    _searchenv (const char *name, const char *var, char *path);

#endif /* _PORT_H */
