/* error.c - map win32 errors to unix/emx errors

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

static const unsigned char nt2emx_errno_table[] =
{
  EINVAL,  EINVAL,       ENOENT,  ENOENT,  EMFILE,  /* 0..4 */
  EACCES,  EBADF,        EIO,     ENOMEM,  EIO,     /* 5..9 */
  EINVAL,  ENOEXEC,      EINVAL,  EINVAL,  EINVAL,  /* 10..14 */
  ENOENT,  EBUSY,        EXDEV,   ENOENT,  EROFS,   /* 15..19 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 20..24 */
  EIO,     EIO,          EIO,     ENOSPC,  EIO,     /* 25..29 */
  EIO,     EIO,          EACCES,  EACCES,  EIO,     /* 30..34 */
  EIO,     EIO,          EIO,     EIO,     ENOSPC,  /* 35..39 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 40..44 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 45..49 */
  EIO,     EIO,          EIO,     EIO,     EBUSY,   /* 50..54 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 55..59 */
  EIO,     ENOSPC,       ENOSPC,  EIO,     EIO,     /* 60..64 */
  EACCES,  EIO,          EIO,     EIO,     EIO,     /* 65..69 */
  EIO,     EIO,          EIO,     EROFS,   EIO,     /* 70..74 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 75..79 */
  EEXIST,  EIO,          ENOENT,  EIO,     EIO,     /* 80..84 */
  EIO,     EIO,          EINVAL,  EIO,     EAGAIN,  /* 85..89 */
  EIO,     EIO,          EIO,     EIO,     EIO,     /* 90..94 */
  EINTR,   EIO,          EIO,     EIO,     EACCES,  /* 95..99 */
  ENOMEM,  EINVAL,       EINVAL,  ENOMEM,  EINVAL,  /* 100..104 */
  EINVAL,  ENOMEM,       EIO,     EACCES,  EPIPE,   /* 105..109 */
  ENOENT,  E2BIG,        ENOSPC,  ENOMEM,  EBADF,   /* 110..114 */
  EINVAL,  EINVAL,       EINVAL,  EINVAL,  EINVAL,  /* 115..119 */
  EINVAL,  EINVAL,       EINVAL,  ENOENT,  EINVAL,  /* 120..124 */
  ENOENT,  ENOENT,       ENOENT,  ECHILD,  ECHILD,  /* 125..129 */
  EACCES,  EINVAL,       ESPIPE,  EINVAL,  EINVAL,  /* 130..134 */
  EINVAL,  EINVAL,       EINVAL,  EINVAL,  EINVAL,  /* 135..139 */
  EINVAL,  EINVAL,       EBUSY,   EINVAL,  EINVAL,  /* 140..144 */
  ENOTEMPTY, EINVAL,     EINVAL,  EBUSY,   EINVAL,  /* 145..149 */
  EINVAL,  EINVAL,       ENOMEM,  EINVAL,  EINVAL,  /* 150..154 */
  EINVAL,  EINVAL,       EINVAL,  EINVAL,  EINVAL,  /* 155..159 */
  EINVAL,  EINVAL,       EINVAL,  EINVAL,  EAGAIN,  /* 160..164 */
  EINVAL,  EINVAL,       EACCES,  EINVAL,  EINVAL,  /* 165..169 */
  EBUSY,   EINVAL,       EINVAL,  EINVAL,  EINVAL,  /* 170..174 */
  EINVAL,  EINVAL,       EINVAL,  EINVAL,  EINVAL,  /* 175..179 */
  EINVAL,  EINVAL,       EINVAL,  EEXIST,  ECHILD,  /* 180..184 */
  EINVAL,  EINVAL,       ENOENT,  EINVAL,  EINVAL,  /* 185..189 */
  ENOEXEC, ENOEXEC,      ENOEXEC, ENOEXEC, ENOEXEC, /* 190..194 */
  ENOEXEC, ENOEXEC,      ENOEXEC, ENOEXEC, ENOEXEC, /* 195..199 */
  ENOEXEC, ENOEXEC,      ENOEXEC, ENOENT,  EINVAL,  /* 200..204 */
  EINVAL,  ENAMETOOLONG, EINVAL,  EINVAL,  EINVAL,  /* 205..209 */
  EINVAL,  EINVAL,       EACCES,  ENOEXEC, ENOEXEC, /* 210..214 */
  EINVAL /* 215 */
};

#define NT2EMX_ERROR_TABLE_SIZE sizeof(nt2emx_errno_table)/sizeof(nt2emx_errno_table[0])

int _rsxnt_get_last_errno(void)
{
    int sys_errno = (int) (GetLastError() & 0xffff);

    if (sys_errno <= NT2EMX_ERROR_TABLE_SIZE)
        sys_errno = (int) nt2emx_errno_table[sys_errno];
    else
        sys_errno = EINVAL;

#ifdef EMX_SYS_LIB
  errno = sys_errno;
  return -1;
#else
  return -(sys_errno);
#endif
}

int _rsxnt_errno(int sys_errno)
{
#ifdef EMX_SYS_LIB
  errno = sys_errno;
  return -1;
#else
  return -(sys_errno);
#endif
}

