/* initfile.c - init file mapping (posix to win32)

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

void _rsxnt_init_files(EMXPROCESS *p)
{
    static int inited = 0;
    STARTUPINFO si;
    
    int i;
    HANDLE hFile;
    BOOL console = FALSE;
    int fd;

    if (inited)
        return;
    else
        inited = 1;

    /* for Win32s get 40 Files */
    if (_rsxnt_win32_version == WIN32S) {
        SetHandleCount(N_FILES);
        p->rsxnt_opt.ansi = 0;
    }

    InitializeCriticalSection(&(p->CritSectFiles));

    for (i = 0; i < N_FILES; i++)
        p->file[i].f_handle = INVALID_HANDLE_VALUE;

    /* set stdhandles to 0-2 */
    hFile = GetStdHandle(STD_INPUT_HANDLE);
    if (hFile != INVALID_HANDLE_VALUE) {
        p->file[0].f_mode = HT_DEV_CON;
        p->file[0].f_flags = 0;
        p->file[0].f_handle = hFile;
        console = TRUE;
        // FlushConsoleInputBuffer(hFile);
    }
    hFile = GetStdHandle(STD_OUTPUT_HANDLE);
    if (hFile != INVALID_HANDLE_VALUE) {
        p->file[1].f_mode = HT_DEV_CON;
        p->file[1].f_flags = 0;
        p->file[1].f_handle = hFile;
        console = TRUE;
    }
    hFile = GetStdHandle(STD_ERROR_HANDLE);
    if (hFile != INVALID_HANDLE_VALUE) {
        p->file[2].f_mode = HT_DEV_CON;
        p->file[2].f_flags = 0;
        p->file[2].f_handle = hFile;
        console = TRUE;
    }

    p->umask_bits = 0022;
    p->bConsoleApp = console;

    if (p->bConsoleApp == FALSE) {  /* dummy files for (0-2) */
        p->file[0].f_handle = BAD_FS_HANDLE;
        p->file[1].f_handle = BAD_FS_HANDLE;
        p->file[2].f_handle = BAD_FS_HANDLE;
    }
    fd = 3;

    GetStartupInfo(&si);
    if (si.lpReserved2 != NULL && si.cbReserved2 == sizeof(p->file)) /* spawned by rsxnt */
    {
        memcpy (p->file, si.lpReserved2, sizeof(p->file));

        /* check open files */
        for (i = 3; i < N_FILES; i++) {
            if (p->file[i].f_handle != INVALID_HANDLE_VALUE)
            {
                // check handle (inherit = false)
                if (_rsxnt_get_ht_type(p->file[i].f_handle) == 0xffffffff) {
                    p->file[i].f_mode = p->file[i].f_flags = 0;
                    p->file[i].f_handle = INVALID_HANDLE_VALUE;
                }
            }
        }
    }
    else
    {
        for (i = 0; i < N_FILES; i++) {

            DWORD type = _rsxnt_get_ht_type((HANDLE)i);

            if ((HANDLE)i == p->file[0].f_handle ||
                (HANDLE)i == p->file[1].f_handle ||
                (HANDLE)i == p->file[2].f_handle)
                type = 0xffffffff;

            if (type != 0xffffffff) {
                p->file[fd].f_mode = type;
                p->file[fd].f_flags = 0;
                p->file[fd].f_handle = (HANDLE) i;
                _rsxnt_check_console_handle(p, fd);
                fd++;
            }
        }
    }
}
