/* newfile.c - get CRT handle (for posix handle emulation)

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int _rsxnt_get_new_file(EMXPROCESS *p)
{
    int i;

    EnterCriticalSection(&(p->CritSectFiles));

    for (i = 0; i < N_FILES; i++)
        if (p->file[i].f_handle == INVALID_HANDLE_VALUE) {
            p->file[i].f_handle = BAD_FS_HANDLE;    /* temp. alloc */
            break;
        }

    LeaveCriticalSection(&(p->CritSectFiles));

    return (i == N_FILES) ? -1 : i;
}
