/* st2gmt.c - compute seconds since 1.1.1900

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

#define MINUTE 60L
#define HOUR (60L*MINUTE)
#define DAY (24L*HOUR)
#define YEAR (365L*DAY)

/*
    Converts struct SYSTEMTIME to Unix format
*/
unsigned long _rsxnt_st2gmt(SYSTEMTIME *st)
{
    static long month[12] =
    {
        0L,
        DAY * (long) (31),
        DAY * (long) (31 + 29),
        DAY * (long) (31 + 29 + 31),
        DAY * (long) (31 + 29 + 31 + 30),
        DAY * (long) (31 + 29 + 31 + 30 + 31),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31),
        DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30)
    };

    unsigned long res;
    unsigned long year;

    /* calc date */
    year = st->wYear - 1970L;
    res = YEAR * year + DAY * ((year + 1) / 4);
    res += month[st->wMonth - 1];
    if (st->wMonth > 2 && ((year + 2) % 4))
        res -= DAY;
    res += DAY * (st->wDay - 1);

    /* calc time */
    res += HOUR * (st->wHour);
    res += MINUTE * (st->wMinute);
    res += (st->wSecond);

    return res;
}
