/* ptrace.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

/*
    This modeule is only included by the sys library.
    The dll call _rsxnt_do_ptrace().
*/

int __ptrace (int request, int pid, int addr, int data)
{
  int retv;

  int sys_errno = _rsxnt_do_ptrace(request, pid, addr, data, &retv);

  if (sys_errno < 0)
    errno = -sys_errno;
  else
    errno = 0;

  return retv;
}

#ifdef EMX_SYS_LIB

/* add this function to the constructor list */
extern WAIT_DEBUG _func_rsxnt_wait_debuggee;

static void enable_wait_debug (void)
{
  _func_rsxnt_wait_debuggee = _rsxnt_wait_debuggee;
}

#ifdef COFF
__asm__(".section .ctor; .long _enable_wait_debug; .section .text");
#else
__asm__ ("\t.stabs \"___CTOR_LIST__\", 23, 0, 0, _enable_wait_debug");
#endif

#endif
