/* sigactio.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

static void check_pending(EMXPROCESS *proc, int signum)
{
    struct sigaction *p;

    p = signum - 1 + proc->sigaction;
    if (p->sa_handler == SIG_IGN) {
	if (signum == SIGCHLD)
	    return;
	proc->sig_raised &= ~ SIGMASK(signum);
	    return;
    }
    if (p->sa_handler == SIG_DFL) {
	if (signum != SIGCHLD)
	    return;
	proc->sig_raised &= ~ SIGMASK(signum);
	return;
    }
}

int __sigaction (int signum, const struct sigaction *action,
		struct sigaction *oldaction)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    struct sigaction new_sa, *p;

    if (signum < 1 || signum >= NSIG || signum==SIGKILL)
	return _rsxnt_errno(EINVAL);
    p = signum - 1 + proc->sigaction;
    if (action) {
	memcpy(&new_sa, action, sizeof(struct sigaction));
	new_sa.sa_mask |= SIGMASK(signum);
	new_sa.sa_mask &= SIGBLOCK;
    }
    if (oldaction)
	memcpy(oldaction, p, sizeof(struct sigaction));
    if (action) {
	*p = new_sa;
	check_pending(proc, signum);
    }
#ifdef EMX_SYS_LIB
	_rsxnt_check_signals();
#endif
    return 0;
}
