/* waitpid.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"
#include <string.h>

#ifdef EMX_SYS_LIB /* dynamic link via ctordtor in ptrace() */
extern WAIT_DEBUG _func_rsxnt_wait_debuggee;
#endif

int __waitpid(int pid, int *status, int request)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    int i, tmppid;
    DWORD dwExit;
    DWORD rc;

    if (pid == -1)
        return __wait(status);

    if (p->debuggee.pid == pid && p->debuggee.status)
#ifndef EMX_SYS_LIB
        return _rsxnt_wait_debuggee(status);
#else
        if (_func_rsxnt_wait_debuggee)
            return (*_func_rsxnt_wait_debuggee)(status);
#endif

    for (i = 0; i < MAX_CHILD; i++)
        if (p->childs[i].pid == pid)
            break;
    if (i >= MAX_CHILD)
        return _rsxnt_errno(ECHILD);

    if (request == 1) {
        rc = WaitForSingleObject(p->childs[i].hProcess, 1);
        if (rc == WAIT_FAILED)
            return _rsxnt_errno(ECHILD);
        else if (rc == WAIT_TIMEOUT) {
            *status = 0;
            return 0;
        }
    }
    else {
        rc = WaitForSingleObject(p->childs[i].hProcess, INFINITE);
        if (rc == WAIT_FAILED)
            return _rsxnt_errno(ECHILD);
    }

    GetExitCodeProcess(p->childs[i].hProcess, &dwExit);
    CloseHandle (p->childs[i].hProcess);
    *status = dwExit << 8;

    tmppid = p->childs[i].pid;
    memset (&(p->childs[i]), 0, sizeof(struct child));
    return tmppid;
}
