#ifndef _ACTIONWINDOW_H_
#define _ACTIONWINDOW_H_

#ifndef _DELEGATEWINDOW_H_
#include <pm/DelegateWindow.h>
#endif

#ifndef _COMMANDLIST_H_
#include <pm/CommandList.h>
#endif

@interface ActionWindow : DelegateWindow <Archiving>
{
  CommandList *commandBindings;
  id clientWindow;
  id menu;
}

- init;
- free;

- bindCommand: (ULONG) command withObject: anObject selector: (SEL) aSel;
- findCommandBinding: (ULONG) command;
- (MRESULT) execCommand: (ULONG) command;

- menu;
- createMenu;
- destroyMenu;

- setClientWindow: aClient;
- clientWindow;
- performClose: sender;
- performQuit: sender;

/*
 * Methods for protocol "Archiving"
 */

- awake;
- read: (TypedStream *) aStream;
- write: (TypedStream *) aStream;

@end

#endif
