/* -------------------------------------------------------------------

	Project: Utility class library

	Objective-C interface file for the class string

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.2
	1995-Jul-21			___

 */

#ifndef _STRING_H_
#define _STRING_H_

/*====================================================================
                      Interface of class string                       
====================================================================*/
#include <objc/Object.h>

@interface String : Object
{
  char *stringValue;
}

/* -------------------------- Initialize -------------------------- */
-init;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-(char *) stringValue;
-setStringValue: (char *) aValue;

/* ------------------------ Public methods ------------------------ */
-(BOOL) isEqual: anObject;
-(int) compare: anotherObject;

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end

#endif
