/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.encapsulatedEvents;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Vector;
import sunw.demo.encapsulatedEvents.EncapsulatedEvent;
import sunw.demo.encapsulatedEvents.EncapsulatedEventAdaptorGenerator;
import sunw.demo.encapsulatedEvents.EncapsulatedEventException;
import sunw.demo.encapsulatedEvents.EncapsulatedEventListener;

public abstract class EncapsulatedEventAdaptor {
    protected Object source;
    protected Method addAdaptorMethod;
    protected Method removeAdaptorMethod;
    protected Vector listeners = new Vector(0, 1);
    static /* synthetic */ Class class$java$util$EventListener;

    public static EncapsulatedEventAdaptor getEncapsulatedEventAdaptor(Class clazz, Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException {
        Class clazz2 = null;
        EncapsulatedEventAdaptor encapsulatedEventAdaptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        if (EncapsulatedEventAdaptor.validateEventSource(eventSetDescriptorArray, clazz) == -1) {
            throw new IllegalArgumentException("Object: " + object + " does not source: " + clazz.getName());
        }
        clazz2 = EncapsulatedEventAdaptor.getEncapsulatedEventAdaptorClass(clazz);
        encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)clazz2.newInstance();
        try {
            encapsulatedEventAdaptor.setSource(object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to register with source");
        }
        return encapsulatedEventAdaptor;
    }

    public static Class getEncapsulatedEventAdaptorClass(Class clazz) throws ClassNotFoundException {
        if (!(class$java$util$EventListener != null ? class$java$util$EventListener : (class$java$util$EventListener = EncapsulatedEventAdaptor.class$("java.util.EventListener"))).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class is not a subinterface of java.util.EventListenerEventListener");
        }
        return EncapsulatedEventAdaptorGenerator.getAdaptorClassForListenerClass(clazz);
    }

    protected EncapsulatedEventAdaptor() {
    }

    public abstract Class getListenerClass();

    public String getListenerClassName() {
        return this.getListenerClass().getName();
    }

    public synchronized Object getSource() {
        return this.source;
    }

    private static int validateEventSource(EventSetDescriptor[] eventSetDescriptorArray, Class clazz) {
        int n = 0;
        while (n < eventSetDescriptorArray.length) {
            if (clazz.equals(eventSetDescriptorArray[n].getListenerType())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSource(Object object) throws IntrospectionException, Exception {
        if (this.source != null && object != null && this.source.equals(object)) {
            return;
        }
        if (this.source != null) {
            this.removeAdaptorFromSource();
        }
        if (object == null) {
            this.source = null;
            this.addAdaptorMethod = null;
            this.removeAdaptorMethod = null;
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        int n = EncapsulatedEventAdaptor.validateEventSource(eventSetDescriptorArray, this.getListenerClass());
        if (n == -1) {
            throw new IllegalArgumentException("Object: " + object + " does not source: " + this.getListenerClassName());
        }
        Object object2 = this.source;
        Method method = this.addAdaptorMethod;
        Method method2 = this.removeAdaptorMethod;
        this.source = object;
        this.addAdaptorMethod = eventSetDescriptorArray[n].getAddListenerMethod();
        this.removeAdaptorMethod = eventSetDescriptorArray[n].getRemoveListenerMethod();
        try {
            this.addAdaptorToSource();
            return;
        }
        catch (Exception exception) {
            this.source = object2;
            this.addAdaptorMethod = method;
            this.removeAdaptorMethod = method2;
            if (this.source != null) {
                this.addAdaptorToSource();
            }
            throw exception;
        }
    }

    public void addEncapsulatedEventListener(EncapsulatedEventListener encapsulatedEventListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(encapsulatedEventListener)) {
                this.listeners.addElement(encapsulatedEventListener);
            }
            return;
        }
    }

    public void removeEncapsulatedEventListener(EncapsulatedEventListener encapsulatedEventListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(encapsulatedEventListener)) {
                this.listeners.removeElement(encapsulatedEventListener);
            }
            return;
        }
    }

    public int getEncapsulatedListenerCount() {
        int n;
        Vector vector = this.listeners;
        synchronized (vector) {
            n = this.listeners.size();
        }
        return n;
    }

    public Vector getEncapsulatedListeners() {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        return vector;
    }

    protected void fire(EventObject eventObject, Method method) throws Exception {
        Vector vector = null;
        EncapsulatedEvent encapsulatedEvent = new EncapsulatedEvent(eventObject, method);
        EncapsulatedEventListener encapsulatedEventListener = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                encapsulatedEventListener = (EncapsulatedEventListener)vector.elementAt(n);
                encapsulatedEventListener.encapsulatedEvent(encapsulatedEvent);
            }
            catch (EncapsulatedEventException encapsulatedEventException) {
                this.handleEncapsulatedEventException(encapsulatedEventException, encapsulatedEventListener, method);
            }
            ++n;
        }
    }

    protected void fire(Object[] objectArray, Method method) throws Exception {
        Vector vector = null;
        EncapsulatedEvent encapsulatedEvent = new EncapsulatedEvent(this.source, method, objectArray);
        EncapsulatedEventListener encapsulatedEventListener = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                encapsulatedEventListener = (EncapsulatedEventListener)vector.elementAt(n);
                encapsulatedEventListener.encapsulatedEvent(encapsulatedEvent);
            }
            catch (EncapsulatedEventException encapsulatedEventException) {
                this.handleEncapsulatedEventException(encapsulatedEventException, encapsulatedEventListener, method);
            }
            ++n;
        }
    }

    protected final void handleEncapsulatedEventException(EncapsulatedEventException encapsulatedEventException, EncapsulatedEventListener encapsulatedEventListener, Method method) throws Exception {
        Class clazz = encapsulatedEventException.getExceptionClass();
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].isAssignableFrom(clazz)) {
                throw encapsulatedEventException.getException();
            }
            ++n;
        }
        throw new RuntimeException("Event Source [" + this.source + "] is not prepared to catch [" + encapsulatedEventException.getException() + "] from listener [" + encapsulatedEventListener);
    }

    protected void addAdaptorToSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.addAdaptorMethod.invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("cannot add adaptor [" + this + "] to source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("cannot add adaptor [" + this + "] to source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
            return;
        }
    }

    protected void removeAdaptorFromSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.removeAdaptorMethod.invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

