/*
 * @(#)FontEditor.java	1.22 97/01/10  
 * 
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion bdk_beta
 * 
 */

package sun.beans.editors;

import java.awt.*;
import java.beans.*;

public class FontEditor extends Panel implements java.beans.PropertyEditor {

    public FontEditor() {
	setLayout(null);

	toolkit = Toolkit.getDefaultToolkit();
	fonts = toolkit.getFontList();

	familyChoser = new Choice();
	for (int i = 0; i < fonts.length; i++) {
	    familyChoser.addItem(fonts[i]);
	}
	add(familyChoser);
	familyChoser.reshape(20, 5, 100, 30);

	styleChoser = new Choice();
	for (int i = 0; i < styleNames.length; i++) {
	    styleChoser.addItem(styleNames[i]);
	}
	add(styleChoser);
	styleChoser.reshape(145, 5, 70, 30);

	sizeChoser = new Choice();
	for (int i = 0; i < pointSizes.length; i++) {
	    sizeChoser.addItem("" + pointSizes[i]);
	}
	add(sizeChoser);
	sizeChoser.reshape(220, 5, 70, 30);

	resize(300,40);
    }


    public Dimension preferredSize() {
	return new Dimension(300, 40);
    }

    public void setValue(Object o) {
	font = (Font) o;
	changeFont(font);
        // Update the current GUI choices.
	for (int i = 0; i < fonts.length; i++) {
	    if (fonts[i].equals(font.getFamily())) {
		familyChoser.select(i);
	        break;
	    }
	}
	for (int i = 0; i < styleNames.length; i++) {
	    if (font.getStyle() == styles[i]) {
		styleChoser.select(i);
	        break;
	    }
	}
	for (int i = 0; i < pointSizes.length; i++) {
	    if (font.getSize() <= pointSizes[i]) {
		sizeChoser.select(i);
	        break;
	    }
	}
    }

    private void changeFont(Font f) {
	font = f;
	if (sample != null) {
	    remove(sample);
	}
	sample = new Label(sampleText);
	sample.setFont(font);
	add(sample);
	Component p = getParent();
	if (p != null) {
	    p.invalidate();
	    p.layout();
	}
	invalidate();
	layout();
	repaint();
	support.firePropertyChange("", null, null);
    }

    public Object getValue() {
	return (font);
    }

    public String getJavaInitializationString() {
	return "new java.awt.Font(\"" + font.getFamily() + "\", " +
  	           font.getStyle() + ", " + font.getSize() + ")";
    }

    public boolean action(Event e, Object arg) {
	String family = familyChoser.getSelectedItem();
	int style = styles[styleChoser.getSelectedIndex()];
	int size = pointSizes[sizeChoser.getSelectedIndex()];
	try {
	    Font f = new Font(family, style, size);
	    changeFont(f);
	} catch (Exception ex) {
	    System.err.println("Couldn't create font " + family + "-" +
			styleNames[style] + "-" + size);
	}
	return (false);
    }


    public boolean isPaintable() {
	return true;
    }

    public void paintValue(java.awt.Graphics gfx, java.awt.Rectangle box) {
	// Silent noop.
	Font oldFont = gfx.getFont();
	gfx.setFont(font);
	FontMetrics fm = gfx.getFontMetrics();
	int vpad = (box.height - fm.getAscent())/2;
	gfx.drawString(sampleText, 0, box.height-vpad);
	gfx.setFont(oldFont);
    }

    public String getAsText() {
	return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
	throw new IllegalArgumentException(text);
    }

    public String[] getTags() {
	return null;
    }

    public java.awt.Component getCustomEditor() {
	return this;
    }

    public boolean supportsCustomEditor() {
	return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
	support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
	support.removePropertyChangeListener(l);
    }

    private Font font;
    private Toolkit toolkit;
    private String sampleText = "Abcde...";

    private Label sample;
    private Choice familyChoser;
    private Choice styleChoser;
    private Choice sizeChoser;

    private String fonts[];
    private String[] styleNames = { "plain", "bold", "italic" };
    private int[] styles = { Font.PLAIN, Font.BOLD, Font.ITALIC };
    private int[] pointSizes = { 3, 5, 8, 10, 12, 14, 18, 24, 36, 48 };

    private PropertyChangeSupport support = new PropertyChangeSupport(this);

}

