
/**
 * Pop up a (modal) Message dialog and wait for a user to press "continue".
 */

package sun.beanbox;

import java.awt.*;
import java.awt.event.*;

public class MessageDialog extends Dialog implements ActionListener {

    public MessageDialog(Frame frame, String title, String Message) {
	super(frame, title, true);
    	new WindowCloser(this);
	
	GridBagLayout gridBag = new GridBagLayout();
	setLayout(gridBag);

	// Add a "Label" for reach line of text.
	int width = 400;
	int height = 5;
	while (Message.length() > 0) {
	    int ix = Message.indexOf('\n');
	    String line;
	    if (ix >= 0) {
		line = Message.substring(0, ix);
		Message = Message.substring(ix+1);
	    } else {
		line = Message;
		Message = "";
	    }
	    Label l = new Label(line);
	    GridBagConstraints cons = new GridBagConstraints();
	    cons.gridwidth = GridBagConstraints.REMAINDER;
	    gridBag.setConstraints(l, cons);
	    add(l);
	    height += 20;
	}

	Button b = new Button("Continue");
	b.addActionListener(this);
	GridBagConstraints cons = new GridBagConstraints();
	cons.gridwidth = GridBagConstraints.REMAINDER;
	gridBag.setConstraints(b, cons);
	add(b);
	height += 25;
	height += 35;

        int x = frame.getLocation().x + 30;
        int y = frame.getLocation().y + 100;
        setBounds(x, y, 400, height+5);
        show();
    }

    public void actionPerformed(ActionEvent evt) {
	// our button got pushed.
        dispose();
    }

}
