implementation module deltaEventIO

import StdEnv

import oskernel, ioState, deltaIOSystem, osdebug
from misc import Evaluate_2

from menuDevice   import OpenWindowMenu, ValidateMenuSystem, MenuFunctions
from windowDevice import WindowFunctions
from timerDevice  import TimerFunctions
from dialogDevice import DialogFunctions

:: InitialIO *s :== [s ->  * ( (IOState s) -> (s, IOState s)) ]

/* Starting an interaction: */

StartIO:: !(IOSystem *s (IOState *s)) !*s !(InitialIO *s) !EVENTS -> (!*s, !EVENTS)
StartIO io_system s0 fs events
	=		let! io_system` = Evaluate_2 (SortIOSystem (FinishIOSystem Devices io_system)) OSStartApplication ;
			in (sn,IOStateEvents io_sn)
	where
		  (sn,io_sn)          = DoIO io_functions s1 io_s1
		  (s1,io_s1)          = DoInitialIO fs s0 io_s0
		  io_s0               = OpenIO io_system` io_s`
		  io_s`               = IOStateSetCurrentMenu menusystem io_s
		  io_s                = EmptyIOState events
		  io_functions        = IOSystemGetDoIOFunctions io_sys
		  (menusystem,io_sys) = FetchMenu io_system`

FetchMenu:: (IOSystem s (IOState s)) -> (CurrentMenuSystem s, IOSystem s (IOState s))
FetchMenu [menu : ds]
		= (ValidateMenuSystem menu, [menu : ds])

DoInitialIO:: !(InitialIO *s) !*s !(IOState *s) -> (!*s, !IOState *s)
DoInitialIO [f : fs] s io
	= DoInitialIO fs s` io`
		where
		  (s`, io`) = f s io
DoInitialIO f s io 
	= (s, io)

OpenIO:: !(IOSystem s (IOState s)) !(IOState s) -> IOState s
OpenIO [d : ds] io_state
		= open d (OpenIO ds io_state)
		  where
		  open = Device_OpenFunction (DeviceSystemToDevice d)
OpenIO ds io_state
		= io_state

/* DoIO: Call HandleEventLoop */

DoIO:: ![DoIOFunction *s] !*s !(IOState *s) -> (!*s, !IOState *s)
DoIO io_functions state io_state
	| closed
		= (state`, io_state``)
		= DoIO io_functions state` io_state``
	  where
		  (closed,io_state``) = IOStateClosed io_state`
		  (state`,io_state`)  = LetDevicesDoIO io_functions event state io_state
		  event               = OSGetNextEvent 0

LetDevicesDoIO:: ![DoIOFunction *s] !Event !*s !(IOState *s) -> (!*s, !IOState *s)
LetDevicesDoIO [do_io : do_io`s] event state io_state
	| this_made_sense 
		= (state`, io_state`)
		= LetDevicesDoIO do_io`s event state` io_state`
		  where
		  (this_made_sense,state`,io_state`) = do_io event state io_state
LetDevicesDoIO do_io event state io_state 
		= (state, io_state)

/* Quit the interaction in which this function is applied: */

QuitIO:: !(IOState s) -> IOState s
QuitIO io 
		= let!
		  	strict1 = OSFreeResources
		  in Evaluate_2 (QuitIO` io) strict1

QuitIO`:: !(IOState s) -> IOState s
QuitIO` io_state
	| closed 
		= io_state`
		= QuitIO` (close io_state``)
		  where
		  close               = Device_CloseFunction (DeviceSystemStateToDevice device)
		  (device,io_state``) = IOStateGetAnyDevice io_state`
		  (closed,io_state` ) = IOStateClosed io_state

/*
	Apply a number of IOState transitions on the IOState:
		  the functions will be evaluated from their left to right appearence in the list.
*/
ChangeIOState:: ![(IOState s) ->  IOState s ] !(IOState s) -> IOState s
ChangeIOState [f : fs] io_state 
		= let!
			strict1 = f io_state
		  in ChangeIOState fs strict1
ChangeIOState fs io_state
		= io_state

/* The interface layer to all Event devices: */

Devices :== [TimerDevice, MenuDevice, WindowDevice, DialogDevice]

FinishIOSystem:: ![Device] !(IOSystem s (IOState s)) -> IOSystem s (IOState s)
FinishIOSystem [WindowDevice : ds] io_system
	| IOSystemContainsNoWindows io_system && IOSystemContainsMenu io_system
		=	FinishIOSystem ds (InsertIOSystem window_system WindowDevice (Priority WindowDevice) (RemoveEmptyWindowDevices io_system))
		where
			window_system = WindowSystem [FixedWindow (-1) (0,0) "Dummy OS/2 window" ((0,0),(400,1)) u []]
			u _ s = (s, [])
FinishIOSystem [d : ds] io_system
	| IOSystemContainsDevice io_system d
		= FinishIOSystem ds io_system
		= FinishIOSystem ds (InsertIOSystem (EmptyDevice d) d (Priority d) io_system)
FinishIOSystem ds io_system
		= io_system

EmptyDevice:: !Device -> DeviceSystem s (IOState s)
EmptyDevice MenuDevice   = MenuSystem []
EmptyDevice DialogDevice = DialogSystem []
EmptyDevice WindowDevice = WindowSystem []
EmptyDevice TimerDevice  = TimerSystem []

IOSystemGetDoIOFunctions:: !(IOSystem s (IOState s)) -> [DoIOFunction s]
IOSystemGetDoIOFunctions [d : ds]
		=	let!
				strict1 = Device_DoIOFunction device
				strict2 = IOSystemGetDoIOFunctions ds
			 in [strict1 : strict2]
		  where
		   device  = DeviceSystemToDevice d
IOSystemGetDoIOFunctions ds 
		= []

Device_ShowFunction:: !Device -> ShowFunction s
Device_ShowFunction device
		= show
		  where
		  (show,_,_,_,_) = Device_Functions device

Device_OpenFunction:: !Device -> OpenFunction s
Device_OpenFunction device
		= open
		  where
		  (_,open,_,_,_) = Device_Functions device

Device_DoIOFunction:: !Device -> DoIOFunction s
Device_DoIOFunction device
		= io
		  where
		  (_,_,io,_,_) = Device_Functions device

Device_CloseFunction:: !Device -> CloseFunction s
Device_CloseFunction device
		= close
		  where
		  (_,_,_,close,_) = Device_Functions device

Device_HideFunction:: !Device -> HideFunction s
Device_HideFunction device
		= hide
		  where
		  (_,_,_,_,hide) = Device_Functions device

Device_Functions:: !Device -> DeviceFunctions s
Device_Functions TimerDevice  = TimerFunctions
Device_Functions MenuDevice   = MenuFunctions
Device_Functions WindowDevice = WindowFunctions
Device_Functions DialogDevice = DialogFunctions

SortIOSystem:: !(IOSystem s (IOState s)) -> IOSystem s (IOState s)
SortIOSystem [d : ds]
		= InsertIOSystem d device (Priority device) (SortIOSystem ds)
		  where
		  device = DeviceSystemToDevice d
SortIOSystem ds
		= ds

InsertIOSystem:: !(DeviceSystem s (IOState s)) !Device !Int !(IOSystem s (IOState s)) -> IOSystem s (IOState s)
InsertIOSystem d device priority devices=:[sorted_d : sorted_ds]
	| priority >= Priority (DeviceSystemToDevice sorted_d)
		= [d : devices]
		= let!
			strict1 = InsertIOSystem d device priority sorted_ds
		  in [sorted_d : strict1]
InsertIOSystem d device priority ds
		= [d]

IOSystemContainsDevice:: !(IOSystem s (IOState s)) !Device -> Bool
IOSystemContainsDevice [d : ds] device
	| eq_Device (DeviceSystemToDevice d) device
		= True
		= IOSystemContainsDevice ds device
IOSystemContainsDevice ds device
		= False

IOSystemContainsNoWindows:: !(IOSystem s (IOState s)) -> Bool
IOSystemContainsNoWindows [WindowSystem [w:_] : ds]
	= False
IOSystemContainsNoWindows [d : ds]
	= IOSystemContainsNoWindows ds
IOSystemContainsNoWindows []
	= True

IOSystemContainsMenu:: !(IOSystem s (IOState s)) -> Bool
IOSystemContainsMenu [MenuSystem [m:_] : ds]
	= True
IOSystemContainsMenu [d : ds]
	= IOSystemContainsMenu ds
IOSystemContainsMenu []
	= False

RemoveEmptyWindowDevices [] = []
RemoveEmptyWindowDevices [WindowSystem [] : ds] = RemoveEmptyWindowDevices ds
RemoveEmptyWindowDevices [d : ds] = [d : RemoveEmptyWindowDevices ds]

DeviceSystemToDevice:: !(DeviceSystem s (IOState s)) -> Device
DeviceSystemToDevice (TimerSystem  x) = TimerDevice
DeviceSystemToDevice (WindowSystem x) = WindowDevice
DeviceSystemToDevice (MenuSystem   x) = MenuDevice
DeviceSystemToDevice (DialogSystem x) = DialogDevice

eq_Device:: !Device !Device -> Bool
eq_Device TimerDevice  TimerDevice  = True
eq_Device WindowDevice WindowDevice = True
eq_Device MenuDevice   MenuDevice   = True
eq_Device DialogDevice DialogDevice = True
eq_Device d d`                      = False

/* Starting a nested interaction:

:: NestIO !(IOSystem t (IOState t)) !t !(InitialIO t) !(IOState s) -> (!t, !IOState s)
		  NestIO [] t0 fs io_s -> (t0, io_s)
		  NestIO system t0 fs io_s
   -> (tn, ShowIO (OldIOStateFromNew hidden_io_s io_tn)),
		  (tn, io_tn)       : DoIO io_functions t1 io_t1,
		  (t1, io_t1)       : DoInitialIO fs t0 io_t0,
		  io_t0         : ShowToplevel io_t',
		  io_t'         : OpenIO system' new_io_t,
		  (new_io_t, hidden_io_s)   : NewIOStateFromOld hide_io_s,
		  hide_io_s         : HideIO io_s,
		  io_functions      : IOSystemGetDoIOFunctions io_system',
		  io_system'        : SortIOSystem (FinishIOSystem Devices io_system)

:: HideIO !(IOState s) -> IOState s
		  HideIO io_state -> HideIO' (UEvaluate_2 io_state (HideToplevelX 0)) Devices

:: HideIO' !(IOState s) ![Device] -> IOState s
		  HideIO' io_state [d | ds]
   -> hide io_state''     IF exists
   -> io_state''          : HideIO' io_state' ds,
		  hide                : Device.HideFunction d,
		  (exists, io_state') : IOStateHasDevice io_state d
		  HideIO' io_state ds -> io_state

:: ShowIO !(IOState s) -> IOState s
		  ShowIO io_state
   -> ShowToplevel (ShowIO' io_state Devices)

:: ShowIO' !(IOState s) ![Device] -> IOState s
		  ShowIO' io_state [d | ds]
   -> show io_state''     IF exists
   -> io_state''          : ShowIO' io_state' ds,
		  show                : Device.ShowFunction d,
		  (exists, io_state') : IOStateHasDevice io_state d
		  ShowIO' io_state ds -> io_state

:: HideIO !(IOState s) -> IOState s
		  HideIO io_state -> HideIO' (UEvaluate_2 io_state (HideToplevelX 0)) Devices

:: HideIO' !(IOState s) ![Device] -> IOState s
		  HideIO' io_state [d | ds]
   -> hide io_state''     IF exists
   -> io_state''          : HideIO' io_state' ds,
		  hide                : Device.HideFunction d,
		  (exists, io_state') : IOStateHasDevice io_state d
		  HideIO' io_state ds -> io_state

:: ShowIO !(IOState s) -> IOState s
		  ShowIO io_state
   -> ShowToplevel (ShowIO' io_state Devices)

:: ShowIO' !(IOState s) ![Device] -> IOState s
		  ShowIO' io_state [d | ds]
   -> show io_state''     IF exists
   -> io_state''          : ShowIO' io_state' ds,
		  show                : Device.ShowFunction d,
		  (exists, io_state') : IOStateHasDevice io_state d
		  ShowIO' io_state ds -> io_state
*/

