implementation module tmfile;

import	StdClass;
import	StdInt, StdBool, StdChar, StdString, StdFile, StdArray;
from	deltaSystem import DirSeparator;
from	tm			import Turing, State, Tape, Trans, Head;

    
::	* UFILE	:== * File;
::	* Disk	:==  Files;

     
	DummyTm		:== ([],("",0),"");
	DummyTape	:== ("##",2);
	DummyTrans	:== (("",' '),("",' '));

    

//
//	Write a Turing Machine to a file.
//

WriteTuringToFile	:: Turing String Disk -> (Bool,Disk);
WriteTuringToFile turing fname disk
		| success = 	(True , newd`);
		= 	(False, newd);
			where {
			(closed,newd`)     =: fclose (WritePartsToFile turing file) newd;
			(success,file,newd)=: fopen fname FWriteText disk;
			};

WritePartsToFile	:: Turing UFILE -> UFILE;
WritePartsToFile (trs,tape,state) file =  newf;
			where {
			fil1=: WriteTransitionsToFile trs   file;
			newf=: WriteTapeToFile        tape  fil1;
			};

WriteTransitionsToFile	:: [Trans] UFILE -> UFILE;
WriteTransitionsToFile [] file
		= 	fwrites "\nTape:\n" file;
WriteTransitionsToFile [trans : rest] file
		= 	WriteTransitionsToFile rest (WriteTransitionToFile trans file);

WriteTransitionToFile	:: Trans UFILE -> UFILE;
WriteTransitionToFile ((from_new,head),(to,move)) file =  newf;
			where {
			fil1=: fwrites (String4 from_new) file;
			fil2=: fwritec ' '            fil1;
			fil3=: fwritec head           fil2;
			fil4=: fwrites "  ->  "       fil3;
			fil5=: fwrites (String4 to)   fil4;
			fil6=: fwritec ' '            fil5;
			fil7=: fwritec move           fil6;
			newf=: fwritec '\n'           fil7;
			};

WriteTapeToFile	:: Tape UFILE -> UFILE;
WriteTapeToFile (cont,pos) file =  fwrites (LimitContents cont) file;

LimitContents	:: String -> String;
LimitContents cont
		| first > last =  "##";
		| fgood && lgood =  cont % (dec first, inc last);
		| lgood =  cont % (0, inc last);
		| fgood =  cont % (dec first, lmin1);
		=  cont;
		   where {
		   first=: FirstNonEmpty 0 lmin1 cont;
		   last =: LastNonEmpty lmin1 cont;
		   fgood=: first > 0;
		   lgood=: last < lmin1;
		   lmin1=: dec (size cont);
		   };

FirstNonEmpty	:: Int Int String -> Int;
FirstNonEmpty i len str
		| i > len ||  str.[i]  <> '#' =  i;
		=  FirstNonEmpty (inc i) len str;

LastNonEmpty	:: Int String -> Int;
LastNonEmpty i str
		| i < 0 ||  str.[i]  <> '#' =  i;
		=  LastNonEmpty (dec i) str;

String4	:: String -> String;
String4 str
		| len >= 4 =  str % (0, 3);
		=  str +++  "    " % (0, 3 - len) ;
		   where {
		   len=: size str;
		   };

//
//	Read a Turing Machine from a file
//

ReadTuring	:: String Disk -> (Int, Turing, Disk);
ReadTuring filename disk
		| success =  (linenr,turing,newd);
		=  (-2,DummyTm,dsk1);
		   where {
		   (closed, newd)      =: fclose newf dsk1;
		   (linenr,turing,newf)=: ReadTuringFile file;
		   (success,file,dsk1) =: fopen filename FReadText disk;
		   };

ReadTuringFile	:: UFILE -> (Int, Turing, UFILE);
ReadTuringFile file
		| linenr == 0 =  (linenr, (trs,(cont,dec (size cont)),"S"), newf);
		=  (linenr, DummyTm, fil1);
		   where {
		   (linenr,trs,fil1)=: ReadTransitions 1 file;
		   (cont      ,newf)=: ReadTape fil1;
		   };

ReadTransitions	:: Int UFILE -> (Int, [Trans], UFILE);
ReadTransitions linenr file
		| sfend file =  (-1    , []            , file);
		| error =  (linenr, []            , fil1);
		| tape =  (0     , []            , fil1);
		| comment =  (lnr   , rest          , newf);
		=  (lnr   , [trans : rest], newf);
		   where {
		   (lnr,rest,newf)           =: ReadTransitions (inc linenr) fil1;
		   (error,tape,comment,trans)=: ParseLine line;
		   (line,fil1)               =: freadline file;
		   };

ParseLine	:: String -> (Bool,Bool,Bool,Trans);
ParseLine s
		| s % (0, 3)  == "Tape" =  (False,True,False,DummyTrans);
		| first == '|' || first == '\n' =  (False,False,True,DummyTrans);
		=  (error,False,False,trans);
		   where {
		   (error,trans)=: ParseTransition s;
		   first        =: s.[0];
		   };

ParseTransition	:: String -> (Bool,Trans);
ParseTransition s
		| e1 || e2 || e3 || e4 || e5 || e6 || e7 =  (True , DummyTrans);
		=  (False, ((from_new,head),(to,move)));
		   where {
		   i0          =: SkipLayout 0 len s;
		   (e1,from_new,i1)=: ParseState   i0 i0 len s;
		   (e2,     i2)=: DemandLayout i1 i1 len s;
		   (e3,head,i3)=: ParseHead    i2    len s;
		   (e4,     i4)=: DemandLayout i3 i3 len s;
		   (e5,to  ,i5)=: ParseState   i4 i4 len s;
		   (e6,     i6)=: DemandLayout i5 i5 len s;
		   (e7,move,i7)=: ParseHead    i6    len s;
		   len         =: size s;
		   };

ParseState	:: Int Int Int String -> (Bool, State, Int);
ParseState b i l s
		| i >= l ||  i - b  > 4 || (is_layout && i == b) =  (True,"",0); 
		| is_layout && i > b =  (False, s % (b, dec i),i);
		=  ParseState b (inc i) l s;
		   where {
		   is_layout=: IsLayoutChar i s;
		   };

ParseHead	:: Int Int String -> (Bool, Char, Int);
ParseHead i l s
		| i >= l || IsLayoutChar i s =  (True,' ',0);
		=  (False,s.[i],inc i);

DemandLayout	:: Int Int Int String -> (Bool, Int);
DemandLayout b i l s
		| i >= l || (not_is_layout && i == b) =  (True ,0);
		| not_is_layout && i > b =  (False,i);
		=  DemandLayout b (inc i) l s;
		   where {
		   not_is_layout=: not (IsLayoutChar i s);
		   };

SkipLayout	:: Int Int String -> Int;
SkipLayout i l s
		| i >= l =  dec i;
		| IsLayoutChar i s =  SkipLayout (inc i) l s;
		=  i;

IsLayoutChar	:: Int String -> Bool;
IsLayoutChar i s
		| c == ' ' || c == '(' || c == ')' || c == '-' || c == '>' ||
		            c == ',' || c == '.' || c == '[' || c == ']' || c == '{' ||
		            c == '}' || c == ';' || c == ':' =  True;
		=  False;
		   where {
		   c=: s.[i];
		   };

ReadTape	:: UFILE -> (String, UFILE);
ReadTape file
		| line == "" =  ("##",newf);
		| first <> '|' && first <> '\n' =  (ParseTape 0 (size line) line, newf);
		=  ReadTape newf;
		   where {
		   (line,newf)=: freadline file;
		   first      =: line.[0];
		   };

ParseTape	:: Int Int String -> String;
ParseTape i l s
		| i >= l =  s;
		| char == ' ' || char == '|' || char == '\n' =  s % (0, dec i);
		=  ParseTape (inc i) l s;
		   where {
		   char=: s.[i];
		   };

//
//	Given a pathname, return the filename (remove the path).
//

RemovePath	:: String -> String;
RemovePath s
	| found = 	s % (inc position, length_min_1);
	= 	s;
		where {
		(found,position)=: LastColon s length_min_1;
		length_min_1=: dec (size s);
		};

LastColon	:: String Int -> (Bool, Int);
LastColon s i
	| i <= 0 = 	(False,0);
	| DirSeparator ==  s.[i]  =  	(True,i);
	= 	LastColon s (dec i);


//
//	Miscellaneous functions
//

StripNewline	:: String -> String;
StripNewline ""     =  "";
StripNewline string |  string.[last]  <> '\n' =  string;
						=  string % (0, dec last);
						   where {
						   last=: dec (size string);
						   };

Append	:: [x]    x -> [x];
Append []     y =  [y];
Append [x:xs] y =  [x : Append xs y];

StrToInt	:: String -> (Bool,Int);
StrToInt ""     =  (False, 0);
StrToInt string =  TextToNumber string 0;

TextToNumber	:: String Int -> (Bool,Int);
TextToNumber "" n =  (True, n);
TextToNumber s	n 
		| is_digit = 	(True , number);
		= 	(False, 0);
			where {
			(sts, number)=: TextToNumber (s % (1, dec (size s))) ( 10 * n  + d);
			(is_digit, d)=: Digit (s.[0]);
			};

Digit	:: Char -> (Bool, Int);
Digit '0' =  (True, 0); 	  Digit '1' =  (True, 1);
Digit '2' =  (True, 2); 	  Digit '3' =  (True, 3);
Digit '4' =  (True, 4); 	  Digit '5' =  (True, 5);
Digit '6' =  (True, 6); 	  Digit '7' =  (True, 7);
Digit '8' =  (True, 8); 	  Digit '9' =  (True, 9);
Digit chr =  (False,0);

