/*
$Log:   sysclock.c,v $
 * Revision 1.4  94/01/12  15:30:21  mboss
 * Added modifications for Windows NT platform.
 * 
 * Revision 1.3  93/10/27  08:43:35  mboss
 * Addition of Alpha code modifications.  In most places type int and
 * unsigned int have been changed to long and unsigned long.  On 32 bit
 * machines int = long and unsigned = unsigned long.
 * 
 * Revision 1.1  93/03/10  09:31:39  mboss
 * Initial revision
 * 
*/
/* 
    *****************************************************************
    *                                                               *     
    *                                                               *
    *                   C code of SysClock routines                 *
    *                                                               *
    *     (c) copyright  1988 Faculty of Information Technology     *
    *                                                               *     
    *       original module : pjk     Dec 90                        *
    *       modifications   : jrh  28 May 92  Value DateTime        *
    *                              parameters, not reference        *
    *                         pms   9 Feb 93  Merged platform       *
    *                                         specific files        *
    *                         pms  04 Mar 93  Deleted machine.cpp.  *
    *                                         Specific code obtained*
    *                                         via cc switches in    *
    *                                         COMPILEcsrc           *
    *                         pms  18 May 93  Added bsd details for *
    *                                         Apollo                *
    *                         pms  16 Dec 93  Added Windows NT      *
    *                                         changes               *
    *                                                               *
    *****************************************************************
*/
/*
	Get all the right includes for either:
			time.h
			sys/time.h
			or both !!
*/

# ifdef _TIME_H_
#   undef _TIME_H_
# endif
# ifdef opsys_sysV
#   ifdef _APOLLO_SOURCE
#      include <time.h>
#   endif
#   ifdef alpha
#      include <sys/time.h>
#   else
#      include <time.h>
#      include <sys/time.h>
#   endif
# else               /*  BSD Unix */
#   ifdef winnt
#      include <time.h>
#      include <sys\types.h>
#      include <sys\timeb.h>
#   else
#      include <sys/time.h>
#     ifdef sony68k
#      include <time.h>
#     endif
#     ifdef ibmrs6000
#      include <time.h>
#     endif
#     ifdef djgpp
#      include <time.h>
#     endif
#     ifdef os2
#      include <time.h>
#     endif
#   endif
# endif


/************************************************
 *  The C representation of the DateTime TYPE   *
 *  used for storing the present date and time. *
 ************************************************
 */

typedef struct {
		unsigned year;
		unsigned char month;
		unsigned char day;
		unsigned char hour;
		unsigned char minute;
		unsigned char second;
		unsigned char fractions;
		short    int  zone;
		unsigned char SummerTimeFlag;
		} SysClock_DateTime;


/* *************** SysClock_CanGetClock () ***************
 *      This procedure verifies that a system clock
 *      exists and that it can be read. In UNIX
 *      TRUE is returned.
 */

#ifdef KandR_C
    unsigned char SysClock_CanGetClock ()
#else
    unsigned char SysClock_CanGetClock (void)
#endif
 
{
   return ('\1');
 }

/* *************** SysClock_CanSetClock () *************** 
 *      This procedure verifies that a system clock
 *      exists and that it can be set. For UNIX
 *      FALSE is returned.
 */

#ifdef KandR_C
    unsigned char SysClock_CanSetClock ()
#else
    unsigned char SysClock_CanSetClock (void)
#endif

{
   return ('\0');
 }

/* *************** SysClock_IsValidDateTime () ***************
 *      This procedure tests if the DateTime record 
 *      passed to the procedure represents a valid
 *      Time and date.
 */

#ifdef KandR_C
    unsigned char SysClock_IsValidDateTime (userData)
    SysClock_DateTime userData;
#else
    unsigned char SysClock_IsValidDateTime (SysClock_DateTime userData)
#endif

{
   char         isleap,month,day; 
   unsigned     year;

   month = userData.month;
   day = userData.day;
   year = userData.year;

   if (userData.fractions != 0) return ('\0');
   if (userData.second > 59) return ('\0');
   if (userData.minute > 59) return ('\0');
   if (userData.hour > 23) return ('\0');

   isleap = !(year%4) && !(!(year%100) && (year%400));
   if (day < 1) return('\0');
   switch (month)
      {
       case 1 : return (day<=31);
       case 2 : if (isleap) return (day<=29);
		   else return (day<=28);
       case 3 : return (day<=31);
       case 4 : return (day<=30);
       case 5 : return (day<=31);
       case 6 : return (day<=30);
       case 7 : return (day<=31);
       case 8 : return (day<=31);
       case 9 : return (day<=30);
       case 10: return (day<=31);
       case 11: return (day<=30);
       case 12: return (day<=31);
       default : return ('\0');
       }
} 


/* *************** SysClock_GetClock () ***************
 *      This procedure is used to acquire the value of 
 *      the system clock and to produce a DateTime 
 *      structure. 
 */

#ifdef KandR_C
    void SysClock_GetClock (userData)
    SysClock_DateTime *userData;
#else
    void SysClock_GetClock (SysClock_DateTime *userData)
#endif

{

struct tm  *timeStruct;

#ifdef _APOLLO_SOURCE
#  ifdef opsys_sysV
      long int m2time;
      m2ime = time ((long *) 0);
      timeStruct = localtime (&m2time);
#  else
      struct timezone zone;
      struct timeval  m2time;
      gettimeofday(&m2time,&zone);
      timeStruct = localtime(&(m2time.tv_sec));
#  endif
#else
#  ifdef winnt
      struct _timeb zone;
      _ftime(&zone);
      timeStruct = localtime(&(zone.time));
#  else
      struct timezone zone;
      struct timeval  m2time;
      gettimeofday(&m2time,&zone);
      timeStruct = localtime(&(m2time.tv_sec));
#  endif
#endif
      
      userData -> year   = timeStruct -> tm_year + 1900;
      userData -> month  = (unsigned char) timeStruct -> tm_mon +1;
      userData -> day    = (unsigned char) timeStruct -> tm_mday;
      userData -> hour   = (unsigned char) timeStruct -> tm_hour;
      userData -> minute = (unsigned char) timeStruct -> tm_min;
      userData -> second = (unsigned char) timeStruct -> tm_sec;
      userData -> fractions = 0;
# ifdef _APOLLO_SOURCE
#   ifdef opsys_sysV
      userData -> zone = 0;  /* timezone unknown ?? */
#   else
      userData -> zone = zone.tz_minuteswest;
#   endif
# else
#   ifdef winnt
      userData -> zone = zone.timezone;
#   else
      userData -> zone = zone.tz_minuteswest;
#   endif
# endif
      userData -> SummerTimeFlag = (unsigned char)(timeStruct -> tm_isdst );
}

/* *************** SysClock_SetClock () *************** 
 *      This procedure has no code due to the inability
 *      to set the system clock.
 */

#ifdef KandR_C
    void  SysClock_SetClock (userData)
    SysClock_DateTime userData;
#else
    void  SysClock_SetClock (SysClock_DateTime userData)
#endif
{
}
