(****************************************************************)
(*                                                              *)
(*              Modula-2 Compiler Source Module                 *)
(*                                                              *)
(*     (c) copyright 1990 Faculty of Information Technology     *)
(*              Queensland University of Technology             *)
(*                                                              *)
(*     Permission is granted to use, copy and change this       *)
(*     program as long as the copyright message is left intact  *)
(*                                                              *)
(****************************************************************)
IMPLEMENTATION MODULE PathLookup;

  FROM UxFiles IMPORT File, Open, OpenMode, GetMode, FileMode;

  (* precondition  : pathString is nul terminated and has    *)
  (*                 components separated by colon chars,    *)
  (*                 openName is long enough for pathname    *)
  (* postcondition : openFile <> NIL ==> file was found.     *)
  (*                 openName has nul terminated absolute    *)
  (*                 path name, or nul string if not found   *)

  CONST
      PathSep = ";";
      DirSep  = "\";

  PROCEDURE FindAndOpen(pathString   : ARRAY OF CHAR;
                        baseName     : ARRAY OF CHAR;
                        VAR openName : ARRAY OF CHAR;
                        VAR openFile : File);
    CONST nul      = 0C;
    VAR   ch       : CHAR;
          found    : BOOLEAN;
          ix,px,bx : CARDINAL;
  BEGIN
    px := 0;
    LOOP
      (*
         fetch prefix string
      *)
      ix := 0; ch := pathString[px];
      WHILE (ch <> PathSep) AND (ch <> nul) DO
        openName[ix] := ch;
        INC(ix); INC(px);
        IF px > HIGH(pathString) THEN ch := nul;
        ELSE ch := pathString[px];
        END;
      END;
      IF (ix > 0) AND (openName[ix-1] <> DirSep) THEN
        openName[ix] := DirSep; INC(ix);
      END;
      (*
         add base name string
      *)
      bx := 0; ch := baseName[bx];
      WHILE ch <> nul DO
        openName[ix] := ch;
        INC(ix); INC(bx);
        IF bx > HIGH(baseName) THEN ch := nul;
        ELSE ch := baseName[bx];
        END;
      END;
      openName[ix] := nul;
      (*
         now lookup the file
      *)
      Open(openFile,openName,ReadOnly,found);
      IF found THEN RETURN;
      ELSIF (px > HIGH(pathString)) OR
	    (pathString[px] = nul) THEN (* path ended *)
        openName[0] := nul; RETURN;
      ELSE INC(px);
      END;
    END; (* loop *)
  END FindAndOpen;

  (* precondition  : pathString is nul terminated and has    *)
  (*                 components separated by colon chars,    *)
  (*                 openName is long enough for pathname    *)
  (* postcondition : found = TRUE ==> file was found.        *)
  (*                 openName has nul terminated absolute    *)
  (*                 path name, or nul string if not found   *)

  PROCEDURE FindAbsName(pathString   : ARRAY OF CHAR;
                        baseName     : ARRAY OF CHAR;
                        VAR openName : ARRAY OF CHAR;
                        VAR found    : BOOLEAN);
    CONST nul      = 0C;
    VAR   ch       : CHAR;
          ix,px,bx : CARDINAL;
	  perm     : FileMode;
  BEGIN
    px := 0;
    LOOP
      (*
         fetch prefix string
      *)
      ix := 0; ch := pathString[px];
      WHILE (ch <> PathSep) AND (ch <> nul) DO
        openName[ix] := ch;
        INC(ix); INC(px);
        IF px > HIGH(pathString) THEN ch := nul;
        ELSE ch := pathString[px];
        END;
      END;
      IF (ix > 0) AND (openName[ix-1] <> DirSep) THEN
        openName[ix] := DirSep; INC(ix);
      END;
      (*
         add base name string
      *)
      bx := 0; ch := baseName[bx];
      WHILE ch <> nul DO
        openName[ix] := ch;
        INC(ix); INC(bx);
        IF bx > HIGH(baseName) THEN ch := nul;
        ELSE ch := baseName[bx];
        END;
      END;
      openName[ix] := nul;
      (*
         now lookup the file
      *)
      GetMode(openName,perm,found);
      IF found THEN RETURN;
      ELSIF (px > HIGH(pathString)) OR
	    (pathString[px] = nul) THEN (* path ended *)
        openName[0] := nul; RETURN;
      ELSE INC(px);
      END;
    END; (* loop *)
  END FindAbsName;

END PathLookup.
