(****************************************************************)
(*                                                              *)
(*       GPM example for OS/2 Presentation Manager              *)
(*              Example Application Module                      *)
(*                                                              *)
(****************************************************************)

MODULE SpinTest;

  FROM SYSTEM     IMPORT CAST, ADDRESS;
  FROM ProgArgs   IMPORT Assert;
                                    (* Interface to custom ctrl module *)
  FROM SpinCube   IMPORT SS_ERASE, SS_INMOTION, SPINCUBECLASS, SpinCubeInit;

                                    (* Interface to dialog templates *)
  FROM SpinDlg    IMPORT IDM_DLGEDITDIALOG, IDM_ABOUT, IDM_ASSERT, IDM_RANGE,
                         IDD_DLG, IDD_ABOUT, IDC_SPINCUBE;
                         
  FROM OS2        IMPORT            (* #include <os2.h> *)
    HWND, QMSG, HAB, HMQ, RECTL, BOOL, LONG, ULONG, APIRET, NULL, NULLHANDLE,
    MPARAM, MRESULT, PSZ, HPS, MakePSTR, MPFROM2SHORT, SHORT1FROMMP, SHORT2FROMMP, 
    MM_DELETEITEM, SC_RESTORE, SC_SIZE, SC_MINIMIZE, SC_MAXIMIZE,
    WinInitialize, WinCreateMsgQueue, WinGetMsg, WinDispatchMsg,
    WinRegisterClass,   CS_SIZEREDRAW, CS_CLIPCHILDREN, WS_VISIBLE,
    WinCreateStdWindow, FCF_STANDARD, FCF_AUTOICON, FCF_ACCELTABLE,
    WinCreateWindow,    HWND_DESKTOP, HWND_TOP,
    WinBeginPaint, WinFillRect, SYSCLR_WINDOW, WinEndPaint,
    WinSendMsg, WM_PAINT, WM_COMMAND, WM_SIZE, WM_INITDLG,
    WinSetWindowPos, SWP_SIZE, SWP_MOVE,
    WinWindowFromID, FID_SYSMENU, DID_OK,
    WinDefWindowProc, WinDefDlgProc, WinShowWindow,
    WinDlgBox, WinDismissDlg, WinSetDlgItemShort, WinQueryWindowRect,
    WinIsWindow, WinDestroyWindow, WinDestroyMsgQueue, WinTerminate,
    DosExitList, PFNEXITLIST, EXLST_ADD, EXLST_EXIT,
    WinSetWindowULong, WinQueryWindowULong, QWL_STYLE;


  CONST IDR_MAIN = 1;
         BORDER  = 4;


  VAR  hab   : HAB;
       hmq   : HMQ;
       hwnd  : HWND;
       rect  : RECTL;
       qmsg  : QMSG;
       b     : BOOL;
       mr    : MRESULT;
       hwndMainFrame : HWND;
       gahwndSpin    : ARRAY [0 .. 3] OF HWND;

(******************************************************************************
*
*  MainWndProc
*
******************************************************************************)
PROCEDURE MainWndProc(hwnd : HWND; msg : ULONG;
                                   mp1 : MPARAM; mp2 : MPARAM) : MRESULT;

  VAR  width, height : LONG;
       j             : [2000 .. 3000];
       b             : BOOL;
       rc            : ULONG;
       rclUpdate     : RECTL;
       hps           : HPS;
BEGIN
  CASE msg OF
  | WM_PAINT :
    hps := WinBeginPaint(hwnd, NULLHANDLE, rclUpdate);
    b   := WinFillRect(hps, rclUpdate, SYSCLR_WINDOW);
    b   := WinEndPaint(hps);

  | WM_COMMAND :
    CASE SHORT1FROMMP(mp1) OF
    | IDM_DLGEDITDIALOG:
      rc := WinDlgBox(HWND_DESKTOP, hwnd, DlgProc, NULLHANDLE, IDD_DLG, NULL);

    | IDM_ABOUT:
      rc := WinDlgBox(hwnd, hwnd, DlgProc, NULLHANDLE, IDD_ABOUT, NULL);

    | IDM_ASSERT:
      Assert(FALSE,"This is a test of GPM error dialog with automatic resizing facility");

    | IDM_RANGE:
      rc := 1234;
      j  := rc;

    ELSE  (* ignore *)
    END;

  | WM_SIZE :
    (*
     * Resize the controls such that each cover quarter of the client area
     *   (plus a little border).
    *)
    width  := SHORT1FROMMP(mp2);
    height := SHORT2FROMMP(mp2);
    IF (width > 0) AND (height > 0) THEN
      b := WinSetWindowPos(gahwndSpin[0], NULLHANDLE,
                           BORDER, BORDER,
                           width/2 - BORDER, height/2 - BORDER,
                           SWP_SIZE + SWP_MOVE);
      b := WinSetWindowPos(gahwndSpin[1], NULLHANDLE,
                           width/2 + BORDER,   BORDER,
                           width/2 - BORDER*2, height/2 - BORDER,
                           SWP_SIZE + SWP_MOVE);
      b := WinSetWindowPos(gahwndSpin[2], NULLHANDLE,
                           BORDER,           height/2 + BORDER,
                           width/2 - BORDER, height/2 - BORDER*2,
                           SWP_SIZE + SWP_MOVE);
      b := WinSetWindowPos(gahwndSpin[3], NULLHANDLE,
                           width/2 + BORDER,   height/2 + BORDER,
                           width/2 - BORDER*2, height/2 - BORDER*2,
                           SWP_SIZE + SWP_MOVE);
    END;

  ELSE RETURN WinDefWindowProc(hwnd, msg, mp1, mp2);
  END;

  RETURN NULL;
END MainWndProc;


(******************************************************************************
*
*  DlgProc
*
******************************************************************************)
PROCEDURE DlgProc(hwnd : HWND; msg : ULONG;
                               mp1 : MPARAM; mp2 : MPARAM) : MRESULT;
  VAR b : BOOL;
BEGIN
  CASE msg OF
  | WM_INITDLG:
      FixSysMenu(hwnd);

  | WM_COMMAND:
    IF SHORT1FROMMP(mp1) = DID_OK THEN
      b := WinDismissDlg(hwnd, 1);
    END;

  ELSE RETURN WinDefDlgProc(hwnd, msg, mp1, mp2);
  END;

  RETURN NULL;
END DlgProc;


(******************************************************************************
*
* FixSysMenu
*
******************************************************************************)
PROCEDURE FixSysMenu(hwndDlg : HWND);
   VAR hwndMenu : HWND;            (* handle to system menu *)
       mr       : MRESULT;
BEGIN
   hwndMenu := WinWindowFromID(hwndDlg, FID_SYSMENU);

   mr := WinSendMsg(hwndMenu,       (* delete Restore from the system menu *)
                    MM_DELETEITEM,
                    MPFROM2SHORT(SC_RESTORE, 1), NULL);

   mr := WinSendMsg(hwndMenu,       (* delete Size from the system menu *)
                    MM_DELETEITEM,
                    MPFROM2SHORT(SC_SIZE, 1), NULL);

   mr := WinSendMsg(hwndMenu,       (* delete Minimize from the system menu *)
                    MM_DELETEITEM,
                    MPFROM2SHORT(SC_MINIMIZE, 1), NULL);

   mr := WinSendMsg(hwndMenu,       (* delete Maximize from the system menu *)
                    MM_DELETEITEM,
                    MPFROM2SHORT(SC_MAXIMIZE, 1), NULL);
END FixSysMenu;


(******************************************************************************
*
*  ExitProc
*
******************************************************************************)
PROCEDURE ExitProc(usTermCode : ULONG);
  VAR rc : APIRET;
      b  : BOOL;
      pf : ADDRESS;
BEGIN
  IF WinIsWindow(hab, hwndMainFrame) THEN
    b := WinDestroyWindow(hwndMainFrame);
  END;                          (* destroy main window if it exists *)

  b := WinDestroyMsgQueue(hmq);
  b := WinTerminate(hab);

  pf := NULL;                   (* termination complete *)
  rc := DosExitList(EXLST_EXIT, CAST(PFNEXITLIST,pf));
END ExitProc;


(******************************************************************************
*
*  CreateAppWindow
*
******************************************************************************)
PROCEDURE CreateAppWindow() : HWND;

  VAR   hwndMain  : HWND;
        pszClass  : PSZ;
        flCtlData : ULONG;
	flStyle   : ULONG;
        i         : ULONG;
BEGIN
 (*  Register the main client window class
  *  and create the application frame window
  *)
  pszClass := MakePSTR("Main");
  IF NOT WinRegisterClass(hab, pszClass, MainWndProc,
                          CS_SIZEREDRAW + CS_CLIPCHILDREN, 0) THEN
    RETURN NULLHANDLE
  END;

  flCtlData := FCF_STANDARD + FCF_AUTOICON - FCF_ACCELTABLE;
  hwndMainFrame := WinCreateStdWindow(HWND_DESKTOP, 0, flCtlData,
                                      pszClass,
                                      MakePSTR("Spincube Sample"),
                                      WS_VISIBLE,
                                      NULLHANDLE, IDR_MAIN, hwndMain);

  IF hwndMainFrame = NULLHANDLE THEN RETURN NULLHANDLE END;

 (*
  *  Create 4 SpinCube custom controls; we'll size them later
  *  in the WM_SIZE message handler
  *)
  flStyle := WS_VISIBLE;
  FOR i := 0 TO 3 DO
    gahwndSpin[i] := WinCreateWindow(hwndMain,
                                     MakePSTR(SPINCUBECLASS),
                                     MakePSTR(""),
                                     CAST(ULONG,CAST(BITSET,flStyle)
					 + SS_ERASE + SS_INMOTION),
                                     0, 0, 0, 0,
                                     hwndMain, HWND_TOP, i,
                                     NULL, NULL);
  END;

  b := WinShowWindow(hwndMainFrame, TRUE);
  RETURN hwndMain;

END CreateAppWindow;


(******************************************************************************)
BEGIN  (* SpinTest *)

  hab := WinInitialize(0);
  hmq := WinCreateMsgQueue(hab, 0);
  Assert(hmq <> NULLHANDLE, "WinCreateMsgQueue() failed");

 (* Add ExitProc to the exit list to handle the exit processing *)
  Assert(DosExitList(EXLST_ADD, ExitProc) = 0, "DosExitList() failed");

  SpinCubeInit(hab);
  hwnd := CreateAppWindow();
  Assert(hwnd <> NULLHANDLE, "Failed to create application window");

 (*
  * Delete the SS_ERASE to the 1st & 4th controls so we get the
  *   trailing cubes effect.
  *)
  b := WinSetWindowULong(gahwndSpin[0], QWL_STYLE, CAST(ULONG,CAST(BITSET,
               WinQueryWindowULong(gahwndSpin[0], QWL_STYLE)) - SS_ERASE));
  b := WinSetWindowULong(gahwndSpin[3], QWL_STYLE, CAST(ULONG,CAST(BITSET,
               WinQueryWindowULong(gahwndSpin[3], QWL_STYLE)) - SS_ERASE));

 (*
  * Send ourself a WM_SIZE so the controls will get sized appropriately
  *)
  b  := WinQueryWindowRect(hwnd, rect);
  mr := WinSendMsg(hwnd, WM_SIZE, NULL,
                                  MPFROM2SHORT(rect.xRight, rect.yBottom));

 (* Get/Dispatch Message loop *)
  WHILE WinGetMsg(hmq, qmsg, NULLHANDLE, 0, 0) DO
    mr := WinDispatchMsg(hmq, qmsg);
  END;

END SpinTest.
