(*
 *	M T C  -  Modula-2 to C Translator
 *      ----------------------------------
 *
 *	Purpose	: stores and prints error messages
 *
 *	$Author: grosch $
 *	$Date: 1992/08/07 15:50:06 $
 *	$Revision: 1.5 $
 *
 ***)

DEFINITION MODULE Errors;

FROM SYSTEM	IMPORT ADDRESS;
FROM Idents	IMPORT tIdent;
FROM IO		IMPORT tFile;
FROM Positions	IMPORT tPosition;

CONST
  TooManyErrors		= 0	;	(* error codes		*)
  SyntaxError		= 1	;
  ExpectedTokens	= 2	;
  RestartPoint		= 3	;
  TokenInserted		= 4	;
  ReadParseTable	= 5	;
  IllegalChar		= 6	;
  UnclosedComment	= 7	;
  UnclosedString	= 8	;
  CyclicDefMods 	= 9	;
  ModNotFound		= 10	;
  NoNEWPROCESS		= 11	;
  NoTRANSFER		= 12	;
  NoIOTRANSFER		= 13	;
  StructTypeReq		= 14	;
  OpaqueConflict	= 15	;
  ForeignConflict	= 16	;
  Underscores		= 17	;
  OutOfLongRange	= 18	;

  Fatal			= 1	;	(* error classes	*)
  Restriction		= 2	;
  Error			= 3	;
  Warning		= 4	;
  Repair		= 5	;
  Note			= 6	;
  Information		= 7	;

  None			= 0	;	(* info classes		*)
  Integer		= 1	;
  String		= 7	;
  Array			= 8	;
  Ident			= 10	;

(* ErrorMessageP, ErrorMessagePI, ErrorMessage and ErrorMessageI do not	*)
(* return after a report of a fatal error. Instead PrintMessages (TRUE)	*)
(* is called and afterwards the program terminates with exit status 1.	*)

PROCEDURE ErrorMessageP	(ErrorCode, ErrorClass: CARDINAL; Pos: tPosition);
			(* record an error message			*)

PROCEDURE ErrorMessagePI(ErrorCode, ErrorClass: CARDINAL; Pos: tPosition;
			 InfoClass: CARDINAL; Info: ADDRESS);
			(* record an error message with additional	*)
			(* information of type 'InfoClass' at address	*)
			(* 'Info'					*)

(* ErrorMessage and ErrorMessageI are only used by the parser (see	*)
(* interface description of parser generated by ell). Each error	*)
(* message relates to the source file currently parsed.			*)

PROCEDURE ErrorMessage	(ErrorCode, ErrorClass: CARDINAL; Pos: tPosition);
			(* record an error message			*)

PROCEDURE ErrorMessageI	(ErrorCode, ErrorClass: CARDINAL; Pos: tPosition;
			 InfoClass: CARDINAL; Info: ADDRESS);
			(* record an error message with additional	*)
			(* information of type 'InfoClass' at address	*)
			(* 'Info'					*)

PROCEDURE CompilerError	(Proc: ARRAY OF CHAR);
			(* report a compiler error in procedure	'Proc'	*)
			(* and terminate program with exit status 1	*)

PROCEDURE NumberOfErrors(): CARDINAL;
			(* returns total number of errors in error	*)
			(* classes Fatal, Restriction, and Error	*)

PROCEDURE PrintMessages	(NoWarnings: BOOLEAN);
			(* print sorted error messages to StdError	*)

END Errors.
