/*
OBERON-2 LIBRARY MODULE REVISION of inout.c for Modula- 
$Log: in.c,v $
 * Revision 1.1  1994/09/29  04:38:09  mboss
 * Initial revision
 *
 * Revision 1.2  93/03/10  12:30:02  mboss
 * ReadString would fail at end of file, getchar repeatedly returning EOF
 * which test > ' ' in unsigned arithmetic. It is not clear why inout uses
 * unsigned char, but rather than change that, add explicit tests for
 * (unsigned char)EOF.
 * Also remove the 'byte' typedef; unlike m2rts, which uses byte for various
 * 8-bit quantities which need to be signed or unsigned depending on platform,
 * inout is really manipulating chars, and the unsigned variant is used by all
 * platforms.
 * 
 * Revision 1.1  93/03/10  09:18:02  mboss
 * Initial revision
 * 
*/
/* 
    *****************************************************************
    *                                                               *
    *               Modula-2 InOut Libary Implementation            *
    *                                                               *
    *                     C code of InOut routines                  *
    *                                                               *
    *     (c) copyright  1988 Faculty of Information Technology     *
    *                                                               *
    *       original module : mgr august 1988                       *
    *       modifications   : 24-Mar-89 revised ReadInOu            * 
    *                       : 17-May-89 revised ReadStringInOu      *
    *                       :  5-May-90 jrh ReadStringInOu empty    *
    *                                       line fix                *
    *                       : 15-May-90 kjg fix Done handling in    *
    *                                       ReadInt                 *
    *                       :  9-Aug-90 kjg eliminate calls of      *
    *                                       fprintf                 *
    *                       : 11-Aug-90 mgr CloseOutpu=>CloseOutput *
    *                       : 31-Aug-90 jrh Maxlength 15 => 255     *
    *                       : 19-Dec-90 pjk revised ReadInt &       *
    *                                       ReadCard                * 
    *                       :  7-Mar-91 kjg table must be declared  * 
    *                                       static                  *
    *                       :  3-Apr-91 jrh initialize noOvfl       *
    *                       : 13-Apr-91 kjg fix truncations in      *
    *                                       WriteNums               *
    *                       : 29-Apr-91 kjg redirect using file     *
    *                                       handles                 *
    *                       : 30-Aug-91 jrh OpenInput filename by   *
    *                                       read                    *
    *                       : 16-Oct-91 jrh OpenInput/Output dialog *
    *                                   to tty via standard library *
    *                       : 17-Feb-93 pms Merged platform specific*
    *                                       files.                  *
    *                       : 04-Mar-93 pms Deleted machine.cpp     *
    *                                       Specific code obtained  *
    *                                       via cc switches in      *
    *                                       COMPILEcsrc             *
    *                       : 10-Mar-93 jrh ReadString EOF test     *
    *                       : 18-May-93 pms Added Apollo changes    *
    *****************************************************************

 *
 *  Notes on portability --
 *
 *  When moving to 16 bit environments, most int and
 *  unsigned decarators become long int etc.
 */


#include <string.h>
#include <stdio.h>
#include <fcntl.h>

#define TRUE 1
#define FALSE 0
#define MaxLength 255
#define STDIN 0
#define STDOUT 1
/* convention: upper case (STDIN) for standard library file descriptors.
           lower case (stdin) for stdio FILE pointers */

typedef char bool;

typedef short int FileDesc;

unsigned char In_termCh;
bool In_Done;  /* Variables of In */

static char table[17] = "0123456789abcdef"; /* hex translation array */

static char inputPrompt[] = "Enter Input File Name: ";

/*
 *   variable used for redirection
 */

static bool inRedir = FALSE, outRedir = FALSE;
static FileDesc inHandle, outHandle;

/*
 *  The code for this and the next function are lifted from
 *  UxHandles almost verbatim, but now included inline
 */

/* *************** RedirectHandle () *************** */

#ifdef KandR_C
    void In_RedirectHandle (old, new, save, done)
    FileDesc old;
    FileDesc new;
    FileDesc * save;
    char * done;
#endif
#ifdef ANSI_C
    void In_RedirectHandle (FileDesc old, FileDesc new, FileDesc * save,
                         char * done)
#endif


{
    int dummy;

    *done = '\0';
    *save = dup(old);   if (*save == -1) return;
    dummy = close(old); if (dummy == -1) return;
    dummy = dup(new);   if (dummy != old) return;
    dummy = close(new); if (dummy == -1) return;
    *done = '\1';
}

/* *************** RestoreHandle () *************** */

#ifdef KandR_C
    void In_RestoreHandle (old, saved, done)
    FileDesc old;
    FileDesc saved;
    char * done;
#endif
#ifdef ANSI_C
    void In_RestoreHandle (FileDesc old, FileDesc saved, char * done)
#endif

{
    int dummy;

    *done = '\0';
    dummy = close(old); if (dummy == -1) return;
    dummy = dup(saved); if (dummy != old) return;
    dummy = close(saved);   if (dummy == -1) return;
    *done = '\1';
}


/* *************** In_Open ()*************** */

#ifdef KandR_C
    void In_Open ()
#endif
#ifdef ANSI_C
    void In_Open (void)
#endif

{
   unsigned char s[MaxLength]; 
   int i;
   FileDesc fDesc;
   FileDesc TTY;

   /* flush (discard) previous input before any dialog */
   fflush(stdin);
   TTY = open("/dev/tty", O_RDWR);  /* in case stdout is redirected */
   if ( TTY == -1){
      In_Done = FALSE ;
      fputs("Unable to open /dev/tty in Open routine.\n",stderr);
      }
   else {
      write(TTY, inputPrompt, sizeof(inputPrompt));

/* ***** Previous code: *****

      fgets(s,MaxLength,stdin);

   ** caused the first character of the new input file to be lost on HP systems,
      presumably due to some interaction with stdio buffering. Standard library
      input terminates at end-of-line when input is from a tty device, returning
      the newline character, so the ensuing loop still works with:

      read(STDIN,s,MaxLength);

   ** However, uniform handling of redirection prompts and responses - ie
      ALWAYS interactive, suggests instead:

      fgets(s,MaxLength,TTY);

   ** This works fine on DECStation, but echoes the filename input on HP 800 &
      300! So change to all Standard library, and always /dev/tty:
   *****
*/
      read(TTY,s,MaxLength);
      close(TTY);
      for ( i=0; i < MaxLength && s[i] != '\0' && s[i] != '\n'  ; i++)
           ;
      if ( i< MaxLength && s[i] == '\n') /*short file name */ 
         s[i] = '\0';

/* ------------- UxHandles_OpenFileHandle ------------------ */

      fDesc = open(s,O_RDONLY);
      if (inRedir) 
         In_RestoreHandle(STDIN,fDesc,&In_Done);
      else {
         In_RedirectHandle(STDIN,fDesc,&inHandle,&In_Done);
         inRedir = TRUE;
      }
/* --------------------------------------------------------- */

      if (!In_Done){
        fputs("\n\007 ERROR: Unable to open <",stderr);
        fputs(s,stderr);
        fputs("> for reading \007\n",stderr);
        exit(1);
    }
      /*fclose(tty);*/
    }
}


/* *************** In_Close () *************** */

#ifdef KandR_C
    void In_Close ()
#endif
#ifdef ANSI_C
    void In_Close (void)
#endif

{
#ifdef hppa
   fflush(stdin);
#endif
   if (inRedir)
       In_RestoreHandle(STDIN,inHandle,&In_Done);
   inRedir = FALSE;
}


/* *************** In_Char () *************** */

#ifdef KandR_C
    void In_Char (c)
    unsigned char * c;
#endif
#ifdef ANSI_C
    void In_Char (unsigned char *c)
#endif

{
    int iVar;

    In_Done = TRUE;
    *c = iVar = getchar();
    if ( iVar == EOF) {
        In_Done = FALSE;
        *c = NULL;
    }
}


/* *************** In_String () *************** */

#ifdef KandR_C
    void In_String (s, _s_s )
    unsigned char s[];
    unsigned _s_s;
#endif
#ifdef ANSI_C
    void In_String (unsigned char s[], unsigned _s_s)
#endif

{
 int i;
 unsigned char c;
/*
 * Loops below should terminate on (control) characters < ' ';
 * however EOF = -1 = 255 will test > ' ', causing the leading white
 * space loop to fill the string with EOFs and the trailing discard loop
 * to loop forever;
 * so add explicit tests for EOF.
 */
#define uEOF (unsigned char)EOF

 while ( (c=getchar()) == ' ' || c == '\t' ) ;
        /* skips  leading white space */

 s[0] = c ; i = 0;

 /* read string until blank or control character or _s_s+1 characters */

 while ( i < _s_s && s[i] > ' ' && s[i] != uEOF )
    s[++i] = getchar();

 if ( (i < _s_s) ||
      ( (i == _s_s) && ((s[i] <= ' ') || (s[i] = uEOF)) ) ){
    In_termCh= s[i]; 
    s[i]='\0'; } /* terminate short string with null */
 else { /* discard excess characters if any */
    while ( ( c=getchar()) > ' ' && c != uEOF)
      ; 
        In_termCh = c;  }
}


/* *************** In_Name () *************** */

#ifdef KandR_C
    void In_Name (s, _s_s )
    unsigned char s[];
    unsigned _s_s;
#endif
#ifdef ANSI_C
    void In_Name (unsigned char s[], unsigned _s_s)
#endif

{
 int i;
 unsigned char c;
/*
 * Loops below should terminate on (control) characters < ' ';
 * however EOF = -1 = 255 will test > ' ', causing the leading white
 * space loop to fill the string with EOFs and the trailing discard loop
 * to loop forever;
 * so add explicit tests for EOF.
 */
#define uEOF (unsigned char)EOF

 while ( (c=getchar()) == ' ' || c == '\t' || c == '\n' ) ;
        /* skips  leading white space */

 s[0] = c ; i = 0;

 /* read name until non-alpha or dot or _s_s+1 characters */

 while ( i < _s_s && s[i] != uEOF && 
       ((s[i] >= 'a' && s[i] <= 'z') || 
        (s[i] >= 'A' && s[i] <= 'Z') || 
        (s[i] >= '0' && s[i] <= '9') || 
        (s[i] == '.'))
       )
    s[++i] = getchar();

 if ( (i < _s_s) ||
      ( (i == _s_s) && ((s[i] <= ' ') || (s[i] = uEOF)) ) ){
    In_termCh= s[i]; 
    s[i]='\0'; } /* terminate short string with null */
 else { /* discard excess characters if any */
    while (( c=getchar()) != uEOF && 
          ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || 
           (c >= '0' && c <= '9') || (c == '.')))
      ; 
        In_termCh = c;  }
}

/* *************** In_Int () *************** */

#ifdef KandR_C
    void In_Int (i)
    int *i;
#endif
#ifdef ANSI_C
    void In_Int (int *i)
#endif

{
 int nd,nn;
 unsigned char c, first,ovflo;

 while ((c=getchar()) == ' '|| c=='\t' )  ;
            /* skips  leading white space */

 first = c;
 ovflo = FALSE;

 if (c == '+' || c == '-') c=getchar();

 if ( c >= '0' && c <= '9') {
     nd = 0 ;
     do {
         nn = nd * 10 +(int) (c - '0');
     if (nd > 214748365) ovflo = TRUE;  /* ==> maxint DIV 10 */
     nd = nn;
        c=getchar(); 
        }
      while ( c >= '0' && c <= '9') ;

      if (first == '-')  {
          nd = - nd;
          if ((nd <= 0) && !ovflo) In_Done = TRUE;
          else In_Done = FALSE;
      }
      else {
          if ((nd >= 0) && !ovflo) In_Done = TRUE;
          else In_Done = FALSE;
      }
      In_termCh = c;
      *i   = nd;
  }
  else {
      In_Done = FALSE;
      In_termCh = c;
  }
}

/* *************** In_LongInt () *************** */

#ifdef KandR_C
    void In_LongInt (i)
    int *i;
#endif
#ifdef ANSI_C
    void In_LongInt (int *i)
#endif

{
 int nd,nn;
 unsigned char c, first,ovflo;

 while ((c=getchar()) == ' '|| c=='\t' )  ;
            /* skips  leading white space */

 first = c;
 ovflo = FALSE;

 if (c == '+' || c == '-') c=getchar();

 if ( c >= '0' && c <= '9') {
     nd = 0 ;
     do {
         nn = nd * 10 +(int) (c - '0');
     if (nd > 214748365) ovflo = TRUE;  /* ==> maxint DIV 10 */
     nd = nn;
        c=getchar(); 
        }
      while ( c >= '0' && c <= '9') ;

      if (first == '-')  {
          nd = - nd;
          if ((nd <= 0) && !ovflo) In_Done = TRUE;
          else In_Done = FALSE;
      }
      else {
          if ((nd >= 0) && !ovflo) In_Done = TRUE;
          else In_Done = FALSE;
      }
      In_termCh = c;
      *i   = nd;
  }
  else {
      In_Done = FALSE;
      In_termCh = c;
  }
}

/* *************** In_Real () *************** */

#ifdef KandR_C
    void In_Real (x)
    double *x;
#endif
#ifdef ANSI_C
    void In_Real (double *x)
#endif

 /* 1 000-10-00-0-1 */
{
        if (scanf("%lf", x) == 0)
           In_Done = FALSE;
        else
           In_Done = TRUE ;
}


/* *************** In_LongReal () *************** */

#ifdef KandR_C
    void In_LongReal (x)
    double *x;
#endif
#ifdef ANSI_C
    void In_LongReal (double *x)
#endif

 /* 1 000-10-00-0-1 */
{
        if (scanf("%lf", x) == 0)
           In_Done = FALSE;
        else
           In_Done = TRUE ;
}

