/*
OBERON LIBRARY MODULE
$Log: out.c,v $
 * Revision 1.1  1994/09/29  04:38:19  mboss
 * Initial revision
 *
 * Revision 1.2  93/03/10  12:30:02  mboss
 * ReadString would fail at end of file, getchar repeatedly returning EOF
 * which test > ' ' in unsigned arithmetic. It is not clear why inout uses
 * unsigned char, but rather than change that, add explicit tests for
 * (unsigned char)EOF.
 * Also remove the 'byte' typedef; unlike m2rts, which uses byte for various
 * 8-bit quantities which need to be signed or unsigned depending on platform,
 * inout is really manipulating chars, and the unsigned variant is used by all
 * platforms.
 * 
 * Revision 1.1  93/03/10  09:18:02  mboss
 * Initial revision
 * 
*/
/* 
    *****************************************************************
    *                                                               *
    *               Modula-2 InOut Libary Implementation            *
    *                                                               *
    *                     C code of InOut routines                  *
    *                                                               *
    *     (c) copyright  1988 Faculty of Information Technology     *
    *                                                               *
    *       original module : mgr august 1988                       *
    *       modifications   : 24-Mar-89 revised ReadInOu            * 
    *                       : 17-May-89 revised ReadStringInOu      *
    *                       :  5-May-90 jrh ReadStringInOu empty    *
    *                                       line fix                *
    *                       : 15-May-90 kjg fix Done handling in    *
    *                                       ReadInt                 *
    *                       :  9-Aug-90 kjg eliminate calls of      *
    *                                       fprintf                 *
    *                       : 11-Aug-90 mgr CloseOutpu=>CloseOutput *
    *                       : 31-Aug-90 jrh Maxlength 15 => 255     *
    *                       : 19-Dec-90 pjk revised ReadInt &       *
    *                                       ReadCard                * 
    *                       :  7-Mar-91 kjg table must be declared  * 
    *                                       static                  *
    *                       :  3-Apr-91 jrh initialize noOvfl       *
    *                       : 13-Apr-91 kjg fix truncations in      *
    *                                       WriteNums               *
    *                       : 29-Apr-91 kjg redirect using file     *
    *                                       handles                 *
    *                       : 30-Aug-91 jrh OpenInput filename by   *
    *                                       read                    *
    *                       : 16-Oct-91 jrh OpenInput/Output dialog *
    *                                   to tty via standard library *
    *                       : 17-Feb-93 pms Merged platform specific*
    *                                       files.                  *
    *                       : 04-Mar-93 pms Deleted machine.cpp     *
    *                                       Specific code obtained  *
    *                                       via cc switches in      *
    *                                       COMPILEcsrc             *
    *                       : 10-Mar-93 jrh ReadString EOF test     *
    *                       : 18-May-93 pms Added Apollo changes    *
    *****************************************************************

 *
 *  Notes on portability --
 *
 *  When moving to 16 bit environments, most int and
 *  unsigned decarators become long int etc.
 */


#include <string.h>
#include <stdio.h>
#include <fcntl.h>

#define TRUE 1
#define FALSE 0
#define MaxLength 255
#define STDIN 0
#define STDOUT 1
/* convention: upper case (STDIN) for standard library file descriptors.
           lower case (stdin) for stdio FILE pointers */

typedef char bool;

typedef short int FileDesc;

unsigned char Out_termCh;
bool Out_Done;  /* Variables of Out */

static char table[17] = "0123456789abcdef"; /* hex translation array */

static char inputPrompt[] = "Enter Input File Name: ";
static char outputPrompt[] = "Enter Output File Name: ";

/*
 *   variable used for redirection
 */

static bool inRedir = FALSE, outRedir = FALSE;
static FileDesc inHandle, outHandle;

/*
 *  The code for this and the next function are lifted from
 *  UxHandles almost verbatim, but now included inline
 */

/* *************** RedirectHandle () *************** */

#ifdef KandR_C
    void Out_RedirectHandle (old, new, save, done)
    FileDesc old;
    FileDesc new;
    FileDesc * save;
    char * done;
#endif
#ifdef ANSI_C
    void Out_RedirectHandle (FileDesc old, FileDesc new, FileDesc * save,
                         char * done)
#endif


{
    int dummy;

    *done = '\0';
    *save = dup(old);   if (*save == -1) return;
    dummy = close(old); if (dummy == -1) return;
    dummy = dup(new);   if (dummy != old) return;
    dummy = close(new); if (dummy == -1) return;
    *done = '\1';
}

/* *************** RestoreHandle () *************** */

#ifdef KandR_C
    void Out_RestoreHandle (old, saved, done)
    FileDesc old;
    FileDesc saved;
    char * done;
#endif
#ifdef ANSI_C
    void Out_RestoreHandle (FileDesc old, FileDesc saved, char * done)
#endif

{
    int dummy;

    *done = '\0';
    dummy = close(old); if (dummy == -1) return;
    dummy = dup(saved); if (dummy != old) return;
    dummy = close(saved);   if (dummy == -1) return;
    *done = '\1';
}


/* *************** Out_Open () *************** */

#ifdef KandR_C
    void Out_Open ()
#endif
#ifdef ANSI_C
    void Out_Open (void)
#endif

{
   int i;
   unsigned char s[MaxLength]; 
   FileDesc fDesc;
   FileDesc TTY;

   /* flush previous output before any dialog */
   fflush(stdout);
   TTY = open("/dev/tty", O_RDWR); /* if stdin is already redirected */
   if ( TTY == -1){
      Out_Done = FALSE;
      fputs("Unable to open /dev/tty in OpenOutput routine.\n",stderr);
      }
   else {  
/* ***** Previous code: *****

      fputs("Enter Output File Name: ",stdout);

   ** would output the prompt to a redirected output, then read from tty;
      also, on the DECStation, prompt does not appear even on unredirected
      output until after the response. Flushing stdout cures the prompt after
      response problem, and prompt to /dev/tty sorts out the interaction, but as
      noted for OpenInput causes an extra echo of the filename on HP. So:
   *****
*/
      write(TTY, outputPrompt, sizeof(outputPrompt));
/*    fflush(tty);   */
      read(TTY, s, MaxLength);
      close(TTY);
/*      fflush(tty); */
      for ( i=0; i < MaxLength && s[i] != '\0' && s[i] != '\n' ; i++);
      if ( i<MaxLength && s[i] == '\n')
        s[i] = '\0';

/* ------------- UxHandles_OpenFileHandle ------------------ */

      fDesc = open(s,O_WRONLY | O_CREAT,0666);
      if (outRedir)
         Out_RestoreHandle(STDOUT,fDesc,&Out_Done);
      else {
         Out_RedirectHandle(STDOUT,fDesc,&outHandle,&Out_Done);
         outRedir = TRUE;
      }
/* --------------------------------------------------------- */

      if (!Out_Done ){
        fputs("\n\007 ERROR: Unable to open <",stderr);
        fputs(s,stderr);
        fputs("> for output \007\n",stderr);
        exit(1); }
        /* fclose(tty); */
    }
}


/* *************** Out_Close () *************** */

#ifdef KandR_C
    void Out_Close ()
#endif
#ifdef ANSI_C
    void Out_Close (void)
#endif

{
   fflush(stdout);
   if (outRedir)
       Out_RestoreHandle(STDOUT,outHandle,&Out_Done);
   outRedir = FALSE;
}


/* *************** Out_Char () *************** */

#ifdef KandR_C
    void Out_Char (c)
    unsigned char c;
#endif
#ifdef ANSI_C
    void Out_Char (unsigned char c)
#endif

{
     putchar(c);
}


/* *************** Out_Ln () *************** */

#ifdef KandR_C
    void Out_Ln ()
#endif
#ifdef ANSI_C
    void Out_Ln (void)
#endif

{
     putchar('\n');
}


/* *************** Out_String () *************** */

#ifdef KandR_C
    void Out_String (_p_s, _s_s)
    unsigned char *_p_s; 
    unsigned _s_s;
#endif
#ifdef ANSI_C
    void Out_String (unsigned char *_p_s, unsigned _s_s)
#endif

{
 int i ;
 
 for ( i= 0; i <= _s_s && _p_s[i] != '\0' ; putchar(_p_s[i++]))
    ;
}


/* *************** Out_Int () *************** */

#ifdef KandR_C
    void Out_Int (val, len)
    int val; 
    int len;
#endif
#ifdef ANSI_C
    void Out_Int (int val, int len)
#endif

{
    unsigned num;
    unsigned ix;
    unsigned char str[24];
 
    strcpy(str ,"                      0");
    num = (val < 0 ? -val : val);
    ix = 22;
    while (num > 0){
        str [ix ]= (num % 012 + 060);
        num = num / 012;
        ix--;
    }
    if (val < 0) str [ix ] = '-';
    if (len > 22) {
        while (len > 22) {
        putchar(' '); --len;
    }
      }
    else if (str [22 - len ] == ' ') ;
    else {do len ++; while ( str[22 - len] != ' ');}
    fputs(&str[23 - len],stdout);
}


/* *************** Out_Real () *************** */

#ifdef KandR_C
    void Out_Real (x, width)
    double x;
    int width;
#endif
#ifdef ANSI_C
    void Out_Real (double x, int width)
#endif

 /* 1 000-10-00-0-1 */
{
         printf("%*g",width,x);
}

