function [I]=dquad8(Fun,a1,a2,a3,a4)
%
% DQUAD	    Numerically integrates an expression using QUAD8.
%	    I = DQUAD8('exp(-x^2)/(1+x^(1/2))',a,b) approximates,
%
%	                           a
%                                 /        2
%                                |  exp(- x )
%                                |  --------- dx
%                                |        1/2
%                               /    1 + x
%                               b
%
%	    I = DQUAD8('exp(-z^2)/(1+z^(1/2))','z',a,b) integrates
%           with respect to 'z' rather than 'x' (the default).
%	    I = DQUAD8('exp(-z^2)/(1+z^(1/2))','z',a,b,tol) integrates
%	    to a relative error of tol.
%	    See QUAD, QUAD8, DQUAD

% 	D.Thomas  2/93
%	dethomas@athena.mit.edu

var = 'x';
tol=1e-3;
if ( nargin<3 )
	help dquad8
	return
endif
if ( nargin == 3 )
    xmin=a1;
    xmax=a2;
elseif ( nargin == 4 )
   if ( isstr(a1) )
    var=a1;
    xmin=a2;
    xmax=a3;
   else
    xmin=a1;
    xmax=a2;
    tol=a3;
   endif
else
    var=a1;
    xmin=a2;
    xmax=a3;
    tol=a4;
endif

%
%      Change matrix operators to elementwise operators
%
AFun=toascii(Fun);
As1 =toascii('*');
As2 =toascii('/');
As3 =toascii('^');
Acm =toascii('.');
Arp =toascii(' .');
t=sort([find(AFun==As1),find(AFun==As2),find(AFun==As3)]);
[ignore,N]=size(t);
[ignore,M]=size(AFun);
a=1;
AFunx=[];
for i=1:N
  AFunx=[AFunx,AFun(a:(t(i)-1))];
   if ( AFun(t(i)-1) != Acm )
      AFunx=[AFunx,Arp,AFun(t(i))];
   else
      AFunx=[AFunx,AFun(t(i))];
   endif
  a=t(i)+1;
endfor
AFunx=[AFunx,AFun(a:M)];
Funx=setstr(AFunx);

%
%	Write function as /tmp/qxmfun.m and call quad8
%

if exist('qxmfun')
	system("rm -f /tmp/qxmfun.m");
endif
fname='/tmp/qxmfun.m';
fprintf(fname,['function OuTpUt=qxmfun(',var,')\n']);
fprintf(fname,['OuTpUt=',Funx,';']);
A=octavepath();octavepath(['/tmp:',A]);
I=quad8('qxmfun',xmin,xmax,tol);
octavepath(A);
system("rm -f /tmp/qxmfun.m");


endfunction

