function a = trapz(y,x)
%
%
%  a = trapz(y,x)
%
%  find the area under the curve y = f(x) using the trapezoidal rule
%
%   x = vector containing the independent variable data points
%       the elements of x need not be equally spaced
%   y = f(x) = vector of the function values corresponding to the
%       elements in x
%
%  a = the area under f(x) in the interval defined by x
%

% Written by: Duane Hanselman, University of Maine, (207)-581-2246

x = x(:)'; y = y(:)';   % make sure x and y are row vectors
ly = length(y);
lx = length(x);
if (lx != ly) 
	error('trapz: x and y must be the same length')
endif
a = 0.5*( [0 y] + [y 0] ) .* ( [x 0] - [0 x] );
a = sum( a(1,2:ly) );

endfunction
