function v = fvl (r, n, l)
  
# usage:  fvl (r, n, l)
#
# Returns the future value at the end of n periods of an initial lump
# sum investment l, given a per-period interest rate r.

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/30  
# Copyright Dept of Statistics and Probability Theory TU Wien

  if (nargin <> 3)
    usage ("fvl (r, n, l)");
  endif
  
  if !(is_scalar (r) && (r > -1))
    error ("fvl:  r has to be a scalar > -1");
  elseif !(is_scalar (n) && (n > 0))
    error ("fvl:  n has to be a positive scalar");
  elseif !is_scalar (l)
    error ("fvl:  l has to be a scalar");
  endif
  
  v = l * (1 + r)^n;
  
endfunction