function r = irr (p, i)
  
# usage:  irr (p [, i])
#
# Computes the internal rate of return of a series of payments p from
# an initial investment i, i.e., the solution of npv (r, p) = i. 
# If the second argument is omitted, i = 0 is used.
#
# See also:  npv;  pv, rate.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/08/12
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin == 1)
    i = 0;
  elseif !(nargin == 2)
    usage ("irr (p [, i])");
  endif
  
  tmp = output_precision;
  output_precision = 15;
  if !(is_scalar (p) || is_vector (p))
    error ("irr:  p must be a vector");
  else
    p_string = type p;
  endif

  if !is_scalar (i)
    error ("irr:  i must be a scalar");
  endif
  
  string = ["function delta = f (r) ", ...
      "delta = npv (r, %s) - %g;  end"];
  eval (sprintf (string, p_string, i));

  r = fsolve ("f", 0.01);
  
  output_precision = tmp;
  
endfunction
