function n = nper (r, p, a, l, m)
  
# usage:  nper (r, p, a [, l] [, method])
#
# Computes the number of regular payments of p necessary to amortize a
# loan of amount a and interest r.
#
# With the optional scalar argument l, one can specify an additional
# lump-sum payment of l made at the end of the amortization time.
# With the optional string argument `method', one can specify whether
# payments are made at the end ("e", default) or at the beginning
# ("b") of each period.  
#
# Note that the rate r is not specified in percent, i.e., one has to
# write 0.05 rather than 5 %.
#
# See also:  pv, pmt, rate;  npv.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Copyright Dept of Statistics and Probability Theory TU Wien

  if ((nargin < 3) || (nargin > 5))
    usage ("nper (r, p, a [, l] [, method])");
  endif
  
  if !(is_scalar (r) && (r > -1))
    error ("nper:  r must be a scalar > -1");
  elseif !is_scalar (p)
    error ("nper:  p must be a scalar");
  elseif !is_scalar (a)
    error ("nper:  a must be a scalar");
  endif

  if (nargin == 5)
    if !isstr (m)
      error ("nper:  `method' must be a string");
    endif
  elseif (nargin == 4)
    if isstr (l)
      m = l;
      l = 0;
    else
      m = "e";
    endif
  else
    m = "e";
    l = 0;
  endif
  
  if strcmp (m, "b")
    p = p * (1 + r);
  endif
  
  q = (p - r * a) / (p - r * l);
  
  if (q > 0)
    n = - log (q) / log (1 + r);
  else
    n = Inf;
  endif
  
endfunction

