function p = pmt (r, n, a, l, m)
  
# usage:  pmt (r, n, a [, l] [, method])
#
# Compute the amount of periodic payment necessary to amortize a loan
# of amount a with interest rate r in n periods.
#
# With the optional scalar argument l, one can specify an initial
# lump-sum payment.
# With the optional string argument `method', one can specify whether
# payments are made at the end ("e", default) or at the beginning
# ("b") of each period.
#
# See also:  pv, nper, rate
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/11/23
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Copyright Dept of Probability Theory and Statistics TU Wien

  if ((nargin < 3) || (nargin > 5))
    usage ("pmt (r, n, a [, l] [, method])");
  endif
  
  if !(is_scalar (r) && (r > -1))
    error ("pmt:  rate must be a scalar > -1");
  elseif !(is_scalar (n) && (n > 0))
    error ("pmt:  n must be a positive scalar");
  elseif !(is_scalar (a) && (a > 0))
    error ("pmt:  a must be a positive scalar.");
  endif
  
  if (nargin == 5)
    if !isstr (m)
      error ("pmt:  `method' must be a string");
    endif
  elseif (nargin == 4)
    if isstr (l)
      m = l;
      l = 0;
    else
      m = "e";
    endif
  else
    l = 0;
    m = "e";
  endif
  
  p = r * (a - l * (1 + r)^(-n)) / (1 - (1 + r)^(-n));
  
  if strcmp (m, "b")
    p = p / (1 + r);
  endif
  
  
endfunction
      



