function v = pvl (r, n, p)
  
# usage:  pvl (r, n, p)
#
# Returns the present value of an investment that will pay off p in
# one lump sum at the end of n periods, given the interest rate r.

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Copyright Dept of Statistics and Probability Theory TU Wien

  if (nargin <> 3)
    usage ("pvl (r, n, p)");
  endif
  
  if !(is_scalar (r) && (r > -1))
    error ("pvl:  r has to be a scalar > -1");
  elseif !(is_scalar (n) && (n > 0))
    error ("pvl:  n has to be a positive scalar");
  elseif !is_scalar (p)
    error ("pvl:  p has to be a scalar");
  endif
  
  v = p / (1 + r)^n;
  
endfunction
