function r = rate (n, p, v, l, m)

# usage:  rate (n, p, v [, l] [, method])
#
# Computes the rate of return on an investment of present value v
# which pays p in n consecutive periods.
#
# With the optional scalar argument l, one can specify an additional
# lump-sum payment made at the end of n periods.
# With the optional string argument `method', one can specify whether
# payments are made at the end ("e", default) or at the beginning
# ("b") of each period. 
#
# See also:  pv, pmt, nper;  npv.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/06
# Copyright Dept of Statistics and Probability Theory TU Wien
  
  if ((nargin < 3) || (nargin > 5))
    usage ("rate (n, p, v [, l] [, method])");
  endif
  
  if !(is_scalar (n) && (n > 0))
    error ("rate:  n must be a positive scalar");
  elseif !is_scalar (p)
    error ("rate:  p must be a scalar");
  elseif !is_scalar (v)
    error ("rate:  p must be a scalar");
  endif

  if (nargin == 5)
    if !isstr (m)
      error ("rate:  `method' must be a string");
    endif
  elseif (nargin == 4)
    if isstr (l)
      m = l;
      l = 0;
    else
      m = "e";
    endif
  else
    l = 0;
    m = "e";
  endif
  
  if !is_scalar (l)
    error ("rate:  l must be a scalar");
  endif
  
  string = ["function delta = f (r) ", ...
      "delta = pv (r, %g, %g, %g, \"%s\") - %g;  end"];
  eval (sprintf (string, n, p, l, m, v));
  
  [r, info] = fsolve ("f", 0);
  
endfunction