function y = besseli (a, x)

  # usage:  besseli (a, x)
  # 
  # Computes the modified Bessel function 
  #   I_a (x) = i^(-a) J_a (i * x)
  # of the first kind.   
  # 
  # If a is scalar, then I_a (x) is returned for each element of x and
  # vice versa.  If neither a nor x is scalar, the sizes of a and x
  # must agree, and `besseli' is applied pointwise.
  # 
  # Currently, only a = 0 and real x are supported.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jun 4, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    usage ("besseli (a, x)");
  endif
  
  [retval, a, x] = common_size (a, x);
  if (retval > 0)
    error ("besseli:  a and x must be of common size or scalar");
  endif
  
  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  a = reshape (a, 1, s);

  if any ((a != 0) | (x != real (x)))
    error ("besseli:  currently, a must be 0 and x must be real");
  endif
  
  y = i0 (x);
  
  y = reshape (y, r, c);
  
endfunction