function y = besselj (a, x)

  # usage:  besselj (a, x)
  # 
  # Computes the Bessel function J_a (x) of the first kind.   
  # 
  # If a is scalar, then J_a (x) is returned for each element of x and
  # vice versa.  If neither a nor x is scalar, the sizes of a and x
  # must agree, and `besselj' is applied pointwise.
  # 
  # Currently, only a = 0 or 1 and real x are supported.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jun 4, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    usage ("besselj (a, x)");
  endif
  
  [retval, a, x] = common_size (a, x);
  if (retval > 0)
    error ("besselj:  a and x must be of common size or scalar");
  endif
  
  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  a = reshape (a, 1, s);

  if ! all ((a == 0) | (a == 1)) || any (x <> real (x))
    error ("besselj:  currently, a must be 0 or 1 and x must be real");
  endif
  
  y = zeros (1, s);
  
  k = find (a == 0);
  if any (k)
    y(k) = j0 (x(k));
  endif
  
  k = find (a == 1);
  if any (k)
    y(k) = j1 (x(k));
  endif
  
  y = reshape (y, r, c);
  
endfunction