function Y=cdigamma(Z);
% function Y=cdigamma(Z) returns the value of the digamma function for
% complex argument matrix Z.

% Algorithm:
% ----------
% 1) If real(Z)<0, use the reflection formula for Z -> -Z.
% 2) For |Z|>6 use an order-15 Stirling's approximation.
% 3) For the rest, use Psi(z+1)=1/z+Psi(z) and evaluate Psi(z+N) such that
%    |z+N|>6 .

Asymp_coef=[
-0.08333333333333333;    %    -1/12
 0.008333333333333333;   %    +1/120
-0.003968253968253968;   %    -1/252
 0.004166666666666667;   %    +1/240
-0.007575757575757576;   %    -1/132
 0.0210927960927961;     %    +691/32760
-0.08333333333333333;    %    -1/12
];

[r,c]=size(Z); Z=reshape(Z,1,prod(size(Z))); Y=zeros(size(Z));

FN=find(real(Z)<0);
Z(FN)=-Z(FN);
N=36-abs(Z).^2;
II=find(N>0); I2=find(N<=0);
N(II)=ceil(sqrt(N(II)+real(Z(II)).^2)-real(Z(II)));
N(I2)=0*N(I2);
Z(II)=Z(II)+N(II);                     % Make it asymptotic
lZ=log(Z);
Y=lZ-1./Z/2+(exp(-(2:2:2*length(Asymp_coef))'*lZ).'*Asymp_coef).';
for l=II
  Y(l)=Y(l)-sum(1./(Z(l)-(1:N(l))));    % Take back the added N
end
Z(II)=Z(II)-N(II);
II=(imag(Z(FN))==0) & (abs(ceil(Z(FN)-0.5)-(Z(FN)-0.5))<=eps);
F1=FN(find(II)); F2=FN(find(~II));
Y(F1)=Y(F1)+1./Z(F1);
Y(F2)=Y(F2)+1./Z(F2)+pi./tan(pi*Z(F2));

Y=reshape(Y,r,c);


