function Y=cgamma(Z);
% function Y=cgamma(Z) returns the value of the Gamma function for complex
% argument matrix Z.

% Algorithm:
% ----------
% 1) for real Z, use the builtin gamma function.
% 2) If real(Z)<0, use the reflection formula for Z -> -Z.
% 3) For |Z|>6 use an order-15 Stirling's approximation.
% 4) For the rest, use gamma(z+1)=z*gamma(z) and evaluate gamma(z+N) such that
%    |z+N|>6 .

Asymp_coef=[
	+1.0;
	+0.83333333333333333333e-1;
	+0.34722222222222222222e-2;
	-0.26813271604938271605e-2;
	-0.22947209362139917695e-3;
	+0.78403922172006662747e-3;
	+0.69728137583658577743e-4;
	-0.59216643735369388286e-3;
	-0.51717909082605921934e-4;
	+0.83949872067208727999e-3;
	+0.72048954160200105591e-4;
	-0.19144384985654775265e-2;
	-0.16251626278391581690e-3;
	+0.64033628338080697948e-2;
	+0.54016476789260451518e-3;
];

[r,c]=size(Z); Z=reshape(Z,1,prod(size(Z))); Y=zeros(size(Z));

n_real=imag(Z)==0;
n_complex=~n_real;
if any(n_real)
  IN=find(n_real);
  Y(IN)=gamma(real(Z(IN)));
end
if any(n_complex)
  IN=find(n_complex);
  z=Z(IN);
  FN=find(real(z)<0);
  z(FN)=-z(FN);
  N=36-abs(z).^2;
  II=find(N>0); I2=find(N<=0);
  N(II)=ceil(sqrt(N(II)+real(z(II)).^2)-real(z(II)));
  N(I2)=0*N(I2);
  z(II)=z(II)+N(II);
  y=sqrt(2*pi./z).*z.^z.*exp(-z).*(exp(-(0:length(Asymp_coef)-1)'*log(z)).'*Asymp_coef).';
  for l=II
    y(l)=y(l)/prod(z(l)-(1:N(l)));    % Take back the added N
  end
  z(II)=z(II)-N(II);
  y(FN)=-pi./(z(FN).*sin(pi*z(FN)).*y(FN));
  Y(IN)=y;
end

Y=reshape(Y,r,c);

