function Y=cgammaln(Z);
% function Y=cgammaln(Z) returns the value of the log-gamma function for
% complex argument matrix Z.

% Algorithm:
% ----------
% 1) for real Z, use the builtin log-gamma function.
% 2) If real(Z)<0, use the reflection formula for Z -> -Z.
% 3) For |Z|>6 use an order-15 Stirling's approximation.
% 4) Near the zeros |Z+/-1|<=0.1 and |Z+/-2|<=0.1 use a series expansion.
% 5) For the rest, use gamma(z+1)=z*gamma(z) and evaluate gamma(z+N) such that
%    |z+N|>6 .

One_coef=[
    -0.57721566490153286061;
    +0.82246703342411321826;
    -0.40068563438653142846;
    +0.27058080842778454789;
    -0.20738555102867398526;
    +0.16955717699740818997;
    -0.14404989676884611811;
    +0.12550966952474304243;
    -0.11133426586956469049;
    +0.10009945751278180854;
    -0.90954017145829042236e-1;
    +0.83353840546109004037e-1;
    -0.76932516411352191469e-1;
    +0.71432946295361336071e-1;
%    -0.66668705882420468034e-1;
%    +0.62500955141213040754e-1;
%    -0.58823978658684582341e-1;
%    +0.55555767627403611114e-1;
%    -0.52631679379616660732e-1;
];
Asymp_coef=[
 0.08333333333333333;         %	 1/12
-0.002777777777777778;        %	-1/360
 0.0007936507936507937;       %	 1/1260
-0.0005952380952380953;       %	-1/1680
 0.0008417508417508417;       %	 1/1188
-0.001917526917526918;        %	-691/360360
 0.00641025641025641;         %	 1/156
];

[r,c]=size(Z); Z=reshape(Z,1,prod(size(Z))); Y=zeros(size(Z));

n_real=imag(Z)==0;
n_one=~n_real & (abs(Z-1)<=0.1 | abs(Z+1)<=0.1);
n_two=~n_real & (abs(Z-2)<=0.1 | abs(Z+2)<=0.1);
n_complex=~(n_real | n_one | n_two);
if any(n_real)
  IN=find(n_real);
  if exist('OCTAVE_VERSION')
    Y(IN)=lgamma(real(Z(IN)));
  else
    Y(IN)=gammaln(real(Z(IN)));
  end
end
if any(n_one)
  IN=find(n_one);
  z=Z(IN);
  FN=find(abs(z+1)<=0.1);
  z(FN)=-z(FN);
  y=exp((1:length(One_coef))'*log(z-1)).'*One_coef;
  y(FN)=i*pi+log(pi)-log(z)-log(sin(pi*z(FN)))-y(FN);
  Y(IN)=y;  
end
if any(n_two)
  IN=find(n_two);
  z=Z(IN);
  FN=find(abs(z+2)<=0.1);
  z(FN)=-z(FN);
  y=exp((1:length(One_coef))'*log(z-2)).'*One_coef+log(z-1);
  y(FN)=i*pi+log(pi)-log(z)-log(sin(pi*z(FN)))-y(FN);
  Y(IN)=y;  
end
if any(n_complex)
  IN=find(n_complex);
  z=Z(IN);
  FN=find(real(z)<0);
  z(FN)=-z(FN);
  N=36-abs(z).^2;
  II=find(N>0); I2=find(N<=0);
  N(II)=ceil(sqrt(N(II)+real(z(II)).^2)-real(z(II)));
  N(I2)=0*N(I2);
  z(II)=z(II)+N(II);                     % Make it asymptotic
  lz=log(z);
  y=(log(2*pi)-lz)/2+(lz-1).*z+(exp(-(1:2:2*length(Asymp_coef)-1)'*lz).'*Asymp_coef).';
  for l=II
    y(l)=y(l)-sum(log(z(l)-(1:N(l))));    % Take back the added N
  end
  z(II)=z(II)-N(II);
  y(FN)=log(-pi./(z(FN).*sin(pi*z(FN))))-y(FN);
  Y(IN)=y;
end

Y=reshape(Y,r,c);

