function y = erfinv (x)
  
# usage:  erfinv (x)
#
# Computes the inverse of the error function erf.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/09/27
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/02/06
# Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    usage ("erfinv (x)");
  endif
  
  [m, n] = size (x);  
  x = reshape (x, m * n, 1);
  y = zeros (m * n, 1);
  
  i = find ((x < -1) | (x > 1));
  if any (i)
    y(i) = NaN * ones (length (i), 1);
  endif

  y (find (x == -1)) = (-Inf) * ones (sum (x == -1), 1);
  y (find (x == 1)) = Inf * ones (sum (x == 1), 1);
  
  i = find ((x > -1) & (x < 1));
  if any (i)
    z_old = ones (length (i), 1);
    z_new = zeros (length (i), 1);
    while (any (any (abs (z_new - z_old) > eps)))
      z_old = z_new;
      z_new = z_old - (erf (z_old) - x(i)) .* exp (z_old.^2);
    endwhile
    y(i) = z_new;
  endif
  
  y = reshape (y, m, n);
    
endfunction
