function [Jnd,Ynd] = jybess_d(n,x)
%jybess Integer order Hankel functions.
%       [Jnd,Ynd]=JYBESS_d(n,X) = Derivatives of Bessel functions,
%                                 J-sub-n (X) and Y-sub-n(X).

%       The function is evaluated for every point in the array X.
%       The maximal order, n, must be a nonnegative integer scalar.

%       Reference: Abramowitz and Stegun, Handbook of Mathematical
%         Functions, National Bureau of Standards, Applied Math.
%         Series #55, sections 9.1.1, 9.1.89 and 9.12.

%Eyal Doron <doron@mickey.mpi-hd.mpg.de> Fri, 11 Aug 1995 11:23:57 +0100 (MET DST)
%

if nargout==1
  J=jybess(n+1,x);
else
  [J,Y]=jybess(n+1,x);
end
Jnd=[-J(:,2) (J(:,1:n)-J(:,3:n+2))/2];
if nargout==2
  Ynd=[-Y(:,2) (Y(:,1:n)-Y(:,3:n+2))/2];
end
