function [f, e] = log2 (x)

# usage:  y = log2 (x) or [f, e] = log2 (x)
#
# y = log2 (x) returns the logarithm of base 2 of x.
# [f, e] = log2 (x) returns f and e with 1/2 <= abs(f) < 1 and
# x = f * 2^e.

# Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on 1994/10/17
# Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin != 1)
    usage ("y = log2 (x) or [f, e] = log2 (x)");
  endif

  if (nargout < 2)
    f = log (x) / log (2);
  elseif (nargout == 2)
    # Only deal with the real parts ...
    x = real (x);
    # Since log (0) gives problems, 0 entries are replaced by 1.  
    # This is corrected later by multiplication with the sign.
    f = abs (x) + (x == 0);
    e = (floor (log (f) / log (2)) + 1) .* (x <> 0);
    f = sign (x) .* f ./ (2 .^ e);
  else
    error ("log2 takes at most 2 output arguments");
  endif

endfunction

