function y = pow2 (f, e)
  
# usage: y = pow2 (f [, e])
#
# y = pow2 (x) returns 2 .^ x.
# y = pow2 (f, e) returns f .* (2 .^ e).

# Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on 1994/10/17
# Copyright Department of Probability Theory and Statistics TU Wien

  if (nargin == 1)
    y = 2 .^ f;
  elseif (nargin == 2)
    y = f .* (2 .^ e);
  else
    usage ("y = pow2 (f [, e])");
  endif

endfunction
